/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import io.trino.plugin.raptor.legacy.metadata.BucketNode;
import io.trino.plugin.raptor.legacy.metadata.Distribution;
import io.trino.plugin.raptor.legacy.metadata.NodeSize;
import io.trino.plugin.raptor.legacy.metadata.RaptorNode;
import io.trino.plugin.raptor.legacy.metadata.ShardMetadata;
import io.trino.plugin.raptor.legacy.util.UuidUtil;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.sqlobject.config.RegisterArgumentFactory;
import org.jdbi.v3.sqlobject.config.RegisterColumnMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMapper;
import org.jdbi.v3.sqlobject.config.RegisterConstructorMappers;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlBatch;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

@RegisterArgumentFactory(value=UuidUtil.UuidArgumentFactory.class)
@RegisterColumnMapper(value=UuidUtil.UuidColumnMapper.class)
@RegisterConstructorMappers(value={@RegisterConstructorMapper(value=BucketNode.class), @RegisterConstructorMapper(value=NodeSize.class), @RegisterConstructorMapper(value=RaptorNode.class)})
@RegisterRowMapper(value=ShardMetadata.Mapper.class)
public interface ShardDao {
    public static final int CLEANABLE_SHARDS_BATCH_SIZE = 1000;
    public static final int CLEANUP_TRANSACTIONS_BATCH_SIZE = 10000;
    public static final String SHARD_METADATA_COLUMNS = "table_id, shard_id, shard_uuid, bucket_number, row_count, compressed_size, uncompressed_size, xxhash64";

    @SqlUpdate(value="INSERT INTO nodes (node_identifier) VALUES (:nodeIdentifier)")
    @GetGeneratedKeys
    public int insertNode(String var1);

    @SqlUpdate(value="INSERT INTO shard_nodes (shard_id, node_id)\nVALUES ((SELECT shard_id FROM shards WHERE shard_uuid = :shardUuid), :nodeId)")
    public void insertShardNode(UUID var1, int var2);

    @SqlBatch(value="DELETE FROM shard_nodes\nWHERE shard_id = (SELECT shard_id FROM shards WHERE shard_uuid = :shardUuid)\n  AND node_id = :nodeId")
    public void deleteShardNodes(UUID var1, @Bind(value="nodeId") Iterable<Integer> var2);

    @SqlQuery(value="SELECT node_id FROM nodes WHERE node_identifier = :nodeIdentifier")
    public Integer getNodeId(String var1);

    @SqlQuery(value="SELECT node_identifier FROM nodes WHERE node_id = :nodeId")
    public String getNodeIdentifier(int var1);

    @SqlQuery(value="SELECT node_id, node_identifier FROM nodes")
    public List<RaptorNode> getNodes();

    @SqlQuery(value="SELECT table_id, shard_id, shard_uuid, bucket_number, row_count, compressed_size, uncompressed_size, xxhash64 FROM shards WHERE shard_uuid = :shardUuid")
    public ShardMetadata getShard(UUID var1);

    @SqlQuery(value="SELECT table_id, shard_id, shard_uuid, bucket_number, row_count, compressed_size, uncompressed_size, xxhash64\nFROM (\n    SELECT s.*\n    FROM shards s\n    JOIN shard_nodes sn ON (s.shard_id = sn.shard_id)\n    JOIN nodes n ON (sn.node_id = n.node_id)\n    WHERE n.node_identifier = :nodeIdentifier\n      AND s.bucket_number IS NULL\n      AND (s.table_id = :tableId OR :tableId IS NULL)\n  UNION ALL\n    SELECT s.*\n    FROM shards s\n    JOIN tables t ON (s.table_id = t.table_id)\n    JOIN distributions d ON (t.distribution_id = d.distribution_id)\n    JOIN buckets b ON (\n      d.distribution_id = b.distribution_id AND\n      s.bucket_number = b.bucket_number)\n    JOIN nodes n ON (b.node_id = n.node_id)\n    WHERE n.node_identifier = :nodeIdentifier\n      AND (s.table_id = :tableId OR :tableId IS NULL)\n) x")
    public Set<ShardMetadata> getNodeShards(String var1, Long var2);

    @SqlQuery(value="SELECT n.node_identifier, x.bytes\nFROM (\n  SELECT node_id, sum(compressed_size) bytes\n  FROM (\n      SELECT sn.node_id, s.compressed_size\n      FROM shards s\n      JOIN shard_nodes sn ON (s.shard_id = sn.shard_id)\n      WHERE s.bucket_number IS NULL\n    UNION ALL\n      SELECT b.node_id, s.compressed_size\n      FROM shards s\n      JOIN tables t ON (s.table_id = t.table_id)\n      JOIN distributions d ON (t.distribution_id = d.distribution_id)\n      JOIN buckets b ON (\n        d.distribution_id = b.distribution_id AND\n        s.bucket_number = b.bucket_number)\n  ) x\n  GROUP BY node_id\n) x\nJOIN nodes n ON (x.node_id = n.node_id)")
    public Set<NodeSize> getNodeSizes();

    @SqlUpdate(value="DELETE FROM shard_nodes WHERE shard_id IN (\n  SELECT shard_id\n  FROM shards\n  WHERE table_id = :tableId)")
    public void dropShardNodes(long var1);

    @SqlUpdate(value="DELETE FROM shards WHERE table_id = :tableId")
    public void dropShards(long var1);

    @SqlUpdate(value="INSERT INTO external_batches (external_batch_id, successful)\nVALUES (:externalBatchId, TRUE)")
    public void insertExternalBatch(String var1);

    @SqlQuery(value="SELECT count(*)\nFROM external_batches\nWHERE external_batch_id = :externalBatchId")
    public boolean externalBatchExists(String var1);

    @SqlUpdate(value="INSERT INTO transactions (start_time) VALUES (CURRENT_TIMESTAMP)")
    @GetGeneratedKeys
    public long insertTransaction();

    @SqlUpdate(value="UPDATE transactions SET\n  successful = :successful\n, end_time = CURRENT_TIMESTAMP\nWHERE transaction_id = :transactionId\n  AND successful IS NULL")
    public int finalizeTransaction(long var1, boolean var3);

    @SqlQuery(value="SELECT successful FROM transactions WHERE transaction_id = :transactionId")
    public Boolean transactionSuccessful(long var1);

    @SqlUpdate(value="UPDATE transactions SET\n  successful = FALSE\n, end_time = CURRENT_TIMESTAMP\nWHERE successful IS NULL\n  AND start_time < :maxStartTime")
    public void abortOldTransactions(Timestamp var1);

    @SqlUpdate(value="INSERT INTO created_shards (shard_uuid, transaction_id)\nVALUES (:shardUuid, :transactionId)")
    public void insertCreatedShard(UUID var1, long var2);

    @SqlUpdate(value="DELETE FROM created_shards WHERE transaction_id = :transactionId")
    public void deleteCreatedShards(long var1);

    @SqlBatch(value="DELETE FROM created_shards WHERE shard_uuid = :shardUuid")
    public void deleteCreatedShards(@Bind(value="shardUuid") Iterable<UUID> var1);

    default public void insertDeletedShards(Iterable<UUID> shardUuids) {
        throw new UnsupportedOperationException();
    }

    @SqlUpdate(value="INSERT INTO deleted_shards (shard_uuid, delete_time)\nSELECT shard_uuid, CURRENT_TIMESTAMP\nFROM shards\nWHERE table_id = :tableId")
    public void insertDeletedShards(long var1);

    @SqlQuery(value="SELECT s.shard_uuid\nFROM created_shards s\nJOIN transactions t ON (s.transaction_id = t.transaction_id)\nWHERE NOT t.successful\nLIMIT 10000")
    public List<UUID> getOldCreatedShardsBatch();

    @SqlQuery(value="SELECT shard_uuid\nFROM deleted_shards\nWHERE delete_time < :maxDeleteTime\nLIMIT 1000")
    public Set<UUID> getCleanableShardsBatch(Timestamp var1);

    @SqlBatch(value="DELETE FROM deleted_shards WHERE shard_uuid = :shardUuid")
    public void deleteCleanedShards(@Bind(value="shardUuid") Iterable<UUID> var1);

    @SqlBatch(value="INSERT INTO buckets (distribution_id, bucket_number, node_id)\nVALUES (:distributionId, :bucketNumber, :nodeId)\n")
    public void insertBuckets(long var1, @Bind(value="bucketNumber") List<Integer> var3, @Bind(value="nodeId") List<Integer> var4);

    @SqlQuery(value="SELECT b.bucket_number, n.node_identifier\nFROM buckets b\nJOIN nodes n ON (b.node_id = n.node_id)\nWHERE b.distribution_id = :distributionId\nORDER BY b.bucket_number")
    public List<BucketNode> getBucketNodes(long var1);

    @SqlQuery(value="SELECT distribution_id, distribution_name, column_types, bucket_count\nFROM distributions\nWHERE distribution_id IN (SELECT distribution_id FROM tables)")
    public List<Distribution> listActiveDistributions();

    @SqlQuery(value="SELECT SUM(compressed_size)\nFROM tables\nWHERE distribution_id = :distributionId")
    public long getDistributionSizeBytes(long var1);

    @SqlUpdate(value="UPDATE buckets SET node_id = :nodeId\nWHERE distribution_id = :distributionId\n  AND bucket_number = :bucketNumber")
    public void updateBucketNode(long var1, int var3, int var4);

    default public int deleteOldCompletedTransactions(Timestamp maxEndTime) {
        throw new UnsupportedOperationException();
    }
}

