/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.backup;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class BackupConfig {
    private Duration timeout = new Duration(1.0, TimeUnit.MINUTES);
    private int timeoutThreads = 1000;
    private String provider;
    private int backupThreads = 5;

    @NotNull
    @MinDuration(value="1s")
    @MaxDuration(value="1h")
    public @NotNull @MinDuration(value="1s") @MaxDuration(value="1h") Duration getTimeout() {
        return this.timeout;
    }

    @Config(value="backup.timeout")
    @ConfigDescription(value="Timeout for per-shard backup operations")
    public BackupConfig setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="backup.timeout-threads")
    @ConfigDescription(value="Maximum number of timeout threads for backup operations")
    public BackupConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    @Nullable
    public String getProvider() {
        return this.provider;
    }

    @Config(value="backup.provider")
    @ConfigDescription(value="Backup provider to use (supported types: file)")
    public BackupConfig setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getBackupThreads() {
        return this.backupThreads;
    }

    @Config(value="backup.threads")
    @ConfigDescription(value="Maximum number of shards to backup at once")
    public BackupConfig setBackupThreads(int backupThreads) {
        this.backupThreads = backupThreads;
        return this;
    }
}

