/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.util.MetadataUtil;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class RaptorOutputTableHandle
implements ConnectorOutputTableHandle {
    private final long transactionId;
    private final String schemaName;
    private final String tableName;
    private final List<RaptorColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final List<RaptorColumnHandle> sortColumnHandles;
    private final List<SortOrder> sortOrders;
    private final Optional<RaptorColumnHandle> temporalColumnHandle;
    private final OptionalLong distributionId;
    private final OptionalInt bucketCount;
    private final List<RaptorColumnHandle> bucketColumnHandles;
    private final boolean organized;

    @JsonCreator
    public RaptorOutputTableHandle(@JsonProperty(value="transactionId") long transactionId, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="columnHandles") List<RaptorColumnHandle> columnHandles, @JsonProperty(value="columnTypes") List<Type> columnTypes, @JsonProperty(value="sortColumnHandles") List<RaptorColumnHandle> sortColumnHandles, @JsonProperty(value="sortOrders") List<SortOrder> sortOrders, @JsonProperty(value="temporalColumnHandle") Optional<RaptorColumnHandle> temporalColumnHandle, @JsonProperty(value="distributionId") OptionalLong distributionId, @JsonProperty(value="bucketCount") OptionalInt bucketCount, @JsonProperty(value="organized") boolean organized, @JsonProperty(value="bucketColumnHandles") List<RaptorColumnHandle> bucketColumnHandles) {
        this.transactionId = transactionId;
        this.schemaName = MetadataUtil.checkSchemaName(schemaName);
        this.tableName = MetadataUtil.checkTableName(tableName);
        this.columnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHandles, "columnHandles is null"));
        this.columnTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnTypes, "columnTypes is null"));
        this.sortOrders = Objects.requireNonNull(sortOrders, "sortOrders is null");
        this.sortColumnHandles = Objects.requireNonNull(sortColumnHandles, "sortColumnHandles is null");
        this.temporalColumnHandle = Objects.requireNonNull(temporalColumnHandle, "temporalColumnHandle is null");
        this.distributionId = Objects.requireNonNull(distributionId, "distributionId is null");
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        this.bucketColumnHandles = ImmutableList.copyOf((Collection)Objects.requireNonNull(bucketColumnHandles, "bucketColumnHandles is null"));
        this.organized = organized;
    }

    @JsonProperty
    public long getTransactionId() {
        return this.transactionId;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getColumnHandles() {
        return this.columnHandles;
    }

    @JsonProperty
    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getSortColumnHandles() {
        return this.sortColumnHandles;
    }

    @JsonProperty
    public List<SortOrder> getSortOrders() {
        return this.sortOrders;
    }

    @JsonProperty
    public Optional<RaptorColumnHandle> getTemporalColumnHandle() {
        return this.temporalColumnHandle;
    }

    @JsonProperty
    public OptionalLong getDistributionId() {
        return this.distributionId;
    }

    @JsonProperty
    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    @JsonProperty
    public List<RaptorColumnHandle> getBucketColumnHandles() {
        return this.bucketColumnHandles;
    }

    @JsonProperty
    public boolean isOrganized() {
        return this.organized;
    }

    public String toString() {
        return "raptor:" + this.schemaName + "." + this.tableName;
    }
}

