/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.raptor.legacy.metadata.ShardDelta;
import io.trino.plugin.raptor.legacy.metadata.ShardInfo;
import io.trino.plugin.raptor.legacy.storage.ShardRewriter;
import io.trino.plugin.raptor.legacy.storage.StorageManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.MergePage;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.UuidType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;

public class RaptorMergeSink
implements ConnectorMergeSink {
    private static final JsonCodec<ShardInfo> SHARD_INFO_CODEC = JsonCodec.jsonCodec(ShardInfo.class);
    private static final JsonCodec<ShardDelta> SHARD_DELTA_CODEC = JsonCodec.jsonCodec(ShardDelta.class);
    private final ConnectorPageSink pageSink;
    private final StorageManager storageManager;
    private final long transactionId;
    private final int columnCount;
    private final Map<UUID, Map.Entry<OptionalInt, BitSet>> rowsToDelete = new HashMap<UUID, Map.Entry<OptionalInt, BitSet>>();

    public RaptorMergeSink(ConnectorPageSink pageSink, StorageManager storageManager, long transactionId, int columnCount) {
        this.pageSink = Objects.requireNonNull(pageSink, "pageSink is null");
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.transactionId = transactionId;
        this.columnCount = columnCount;
    }

    public void storeMergedRows(Page page) {
        MergePage mergePage = MergePage.createDeleteAndInsertPages((Page)page, (int)this.columnCount);
        mergePage.getInsertionsPage().ifPresent(arg_0 -> ((ConnectorPageSink)this.pageSink).appendPage(arg_0));
        mergePage.getDeletionsPage().ifPresent(deletions -> {
            List fields = RowBlock.getRowFieldsFromBlock((Block)deletions.getBlock(deletions.getChannelCount() - 1));
            Block shardBucketBlock = (Block)fields.get(0);
            Block shardUuidBlock = (Block)fields.get(1);
            Block shardRowIdBlock = (Block)fields.get(2);
            for (int position = 0; position < shardRowIdBlock.getPositionCount(); ++position) {
                OptionalInt bucketNumber = shardBucketBlock.isNull(position) ? OptionalInt.empty() : OptionalInt.of(IntegerType.INTEGER.getInt(shardBucketBlock, position));
                UUID uuid = UuidType.trinoUuidToJavaUuid((Slice)UuidType.UUID.getSlice(shardUuidBlock, position));
                int rowId = Math.toIntExact(BigintType.BIGINT.getLong(shardRowIdBlock, position));
                Map.Entry entry = this.rowsToDelete.computeIfAbsent(uuid, ignored -> Map.entry(bucketNumber, new BitSet()));
                Verify.verify((boolean)((OptionalInt)entry.getKey()).equals(bucketNumber), (String)"multiple bucket numbers for same shard", (Object[])new Object[0]);
                ((BitSet)entry.getValue()).set(rowId);
            }
        });
    }

    public CompletableFuture<Collection<Slice>> finish() {
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        this.rowsToDelete.forEach((uuid, entry) -> {
            OptionalInt bucketNumber = (OptionalInt)entry.getKey();
            BitSet rowIds = (BitSet)entry.getValue();
            ShardRewriter rewriter = this.storageManager.createShardRewriter(this.transactionId, bucketNumber, (UUID)uuid);
            futures.add(rewriter.rewrite(rowIds));
        });
        futures.add(this.pageSink.finish().thenApply(slices -> {
            List newShards = (List)slices.stream().map(slice -> (ShardInfo)SHARD_INFO_CODEC.fromJson(slice.getBytes())).collect(ImmutableList.toImmutableList());
            ShardDelta delta = new ShardDelta((List<UUID>)ImmutableList.of(), newShards);
            return ImmutableList.of((Object)Slices.wrappedBuffer((byte[])SHARD_DELTA_CODEC.toJsonBytes((Object)delta)));
        }));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new)).thenApply(ignored -> futures.stream().map(CompletableFuture::join).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList()));
    }

    public void abort() {
        this.pageSink.abort();
    }
}

