/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarcharType;
import java.util.Objects;

public final class RaptorColumnHandle
implements ColumnHandle {
    private static final long SHARD_ROW_ID_COLUMN_ID = -1L;
    public static final long SHARD_UUID_COLUMN_ID = -2L;
    public static final String SHARD_UUID_COLUMN_NAME = "$shard_uuid";
    public static final Type SHARD_UUID_COLUMN_TYPE = VarcharType.createVarcharType((int)36);
    public static final long BUCKET_NUMBER_COLUMN_ID = -3L;
    public static final String BUCKET_NUMBER_COLUMN_NAME = "$bucket_number";
    private static final long MERGE_ROW_ID_COLUMN_ID = -4L;
    private static final String MERGE_ROW_ID_COLUMN_NAME = "$merge_row_id";
    private static final Type MERGE_ROW_ID_COLUMN_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"bucket", (Type)IntegerType.INTEGER), RowType.field((String)"uuid", (Type)UuidType.UUID), RowType.field((String)"row_id", (Type)BigintType.BIGINT)});
    private final String columnName;
    private final long columnId;
    private final Type columnType;

    @JsonCreator
    public RaptorColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnId") long columnId, @JsonProperty(value="columnType") Type columnType) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.columnId = columnId;
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public long getColumnId() {
        return this.columnId;
    }

    @JsonProperty
    public Type getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.columnName + ":" + this.columnId + ":" + this.columnType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RaptorColumnHandle other = (RaptorColumnHandle)obj;
        return Objects.equals(this.columnId, other.columnId);
    }

    public int hashCode() {
        return Objects.hash(this.columnId);
    }

    public boolean isShardUuid() {
        return RaptorColumnHandle.isShardUuidColumn(this.columnId);
    }

    public boolean isBucketNumber() {
        return RaptorColumnHandle.isBucketNumberColumn(this.columnId);
    }

    public static boolean isShardRowIdColumn(long columnId) {
        return columnId == -1L;
    }

    public static boolean isShardUuidColumn(long columnId) {
        return columnId == -2L;
    }

    public static RaptorColumnHandle shardUuidColumnHandle() {
        return new RaptorColumnHandle(SHARD_UUID_COLUMN_NAME, -2L, SHARD_UUID_COLUMN_TYPE);
    }

    public static boolean isBucketNumberColumn(long columnId) {
        return columnId == -3L;
    }

    public static RaptorColumnHandle bucketNumberColumnHandle() {
        return new RaptorColumnHandle(BUCKET_NUMBER_COLUMN_NAME, -3L, (Type)IntegerType.INTEGER);
    }

    public static RaptorColumnHandle mergeRowIdHandle() {
        return new RaptorColumnHandle(MERGE_ROW_ID_COLUMN_NAME, -4L, MERGE_ROW_ID_COLUMN_TYPE);
    }

    public static boolean isMergeRowIdColumn(long columnId) {
        return columnId == -4L;
    }

    public static boolean isHiddenColumn(long columnId) {
        return columnId < 0L;
    }
}

