/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ReadOnlyAccessControl
implements ConnectorAccessControl {
    public void checkCanShowSchemas(ConnectorSecurityContext context) {
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return schemaNames;
    }

    public void checkCanAddColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyAddColumn((String)tableName.toString());
    }

    public void checkCanDropColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDropColumn((String)tableName.toString());
    }

    public void checkCanShowCreateSchema(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanShowCreateTable(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public void checkCanCreateTable(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateTable((String)tableName.toString());
    }

    public void checkCanDropTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDropTable((String)tableName.toString());
    }

    public void checkCanRenameTable(ConnectorSecurityContext context, SchemaTableName tableName, SchemaTableName newTableName) {
        AccessDeniedException.denyRenameTable((String)tableName.toString(), (String)newTableName.toString());
    }

    public void checkCanSetTableProperties(ConnectorSecurityContext context, SchemaTableName tableName, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetTableProperties((String)tableName.toString());
    }

    public void checkCanSetTableComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyCommentTable((String)tableName.toString());
    }

    public void checkCanSetViewComment(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyCommentView((String)viewName.toString());
    }

    public void checkCanShowTables(ConnectorSecurityContext context, String schemaName) {
    }

    public void checkCanSetColumnComment(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyCommentColumn((String)tableName.toString());
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(ConnectorSecurityContext context, SchemaTableName tableName) {
    }

    public Set<String> filterColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columns) {
        return columns;
    }

    public void checkCanRenameColumn(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyRenameColumn((String)tableName.toString());
    }

    public void checkCanSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanInsertIntoTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyInsertTable((String)tableName.toString());
    }

    public void checkCanDeleteFromTable(ConnectorSecurityContext context, SchemaTableName tableName) {
        AccessDeniedException.denyDeleteTable((String)tableName.toString());
    }

    public void checkCanUpdateTableColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> updatedColumns) {
        AccessDeniedException.denyUpdateTableColumns((String)tableName.toString(), updatedColumns);
    }

    public void checkCanCreateView(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyCreateView((String)viewName.toString());
    }

    public void checkCanRenameView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        AccessDeniedException.denyRenameView((String)viewName.toString(), (String)newViewName.toString());
    }

    public void checkCanDropView(ConnectorSecurityContext context, SchemaTableName viewName) {
        AccessDeniedException.denyDropView((String)viewName.toString());
    }

    public void checkCanCreateViewWithSelectFromColumns(ConnectorSecurityContext context, SchemaTableName tableName, Set<String> columnNames) {
    }

    public void checkCanCreateMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Object> properties) {
        AccessDeniedException.denyCreateMaterializedView((String)materializedViewName.toString());
    }

    public void checkCanRefreshMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        AccessDeniedException.denyRefreshMaterializedView((String)materializedViewName.toString());
    }

    public void checkCanDropMaterializedView(ConnectorSecurityContext context, SchemaTableName materializedViewName) {
        AccessDeniedException.denyDropMaterializedView((String)materializedViewName.toString());
    }

    public void checkCanRenameMaterializedView(ConnectorSecurityContext context, SchemaTableName viewName, SchemaTableName newViewName) {
        AccessDeniedException.denyRenameMaterializedView((String)viewName.toString(), (String)newViewName.toString());
    }

    public void checkCanSetMaterializedViewProperties(ConnectorSecurityContext context, SchemaTableName materializedViewName, Map<String, Optional<Object>> properties) {
        AccessDeniedException.denySetMaterializedViewProperties((String)materializedViewName.toString());
    }

    public void checkCanSetCatalogSessionProperty(ConnectorSecurityContext context, String propertyName) {
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        AccessDeniedException.denyGrantTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        AccessDeniedException.denyRevokeTablePrivilege((String)privilege.name(), (String)tableName.toString());
    }

    public void checkCanShowRoleAuthorizationDescriptors(ConnectorSecurityContext context) {
    }

    public void checkCanShowRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(ConnectorSecurityContext context) {
    }

    public void checkCanShowRoleGrants(ConnectorSecurityContext context) {
    }
}

