/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.azure;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.options.BlobInputStreamOptions;
import com.azure.storage.blob.specialized.BlobInputStream;
import com.google.common.base.Preconditions;
import io.trino.filesystem.TrinoInput;
import io.trino.filesystem.azure.AzureLocation;
import io.trino.filesystem.azure.AzureUtils;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import java.util.OptionalLong;

class AzureInput
implements TrinoInput {
    private final AzureLocation location;
    private final BlobClient blobClient;
    private final int readBlockSize;
    private OptionalLong length;
    private boolean closed;

    public AzureInput(AzureLocation location, BlobClient blobClient, int readBlockSize, OptionalLong length) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.blobClient = Objects.requireNonNull(blobClient, "blobClient is null");
        Preconditions.checkArgument((readBlockSize >= 0 ? 1 : 0) != 0, (Object)"readBlockSize is negative");
        this.readBlockSize = readBlockSize;
        this.length = Objects.requireNonNull(length, "length is null");
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Negative seek offset");
        }
        Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
        if (bufferLength == 0) {
            return;
        }
        BlobInputStreamOptions options = new BlobInputStreamOptions().setRange(new BlobRange(position, Long.valueOf(bufferLength))).setBlockSize(Integer.valueOf(this.readBlockSize));
        try (BlobInputStream blobInputStream = this.blobClient.openInputStream(options);){
            long fileSize = blobInputStream.getProperties().getBlobSize();
            if (position >= fileSize) {
                throw new IOException("Cannot read at %s. File size is %s: %s".formatted(position, fileSize, this.location));
            }
            int readSize = blobInputStream.readNBytes(buffer, bufferOffset, bufferLength);
            if (readSize != bufferLength) {
                throw new EOFException("End of file reached before reading fully: " + this.location);
            }
        }
        catch (RuntimeException e) {
            throw AzureUtils.handleAzureException(e, "reading file", this.location);
        }
    }

    public int readTail(byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        int n;
        block9: {
            this.ensureOpen();
            Objects.checkFromIndexSize(bufferOffset, bufferLength, buffer.length);
            if (this.length.isEmpty()) {
                this.length = OptionalLong.of(this.blobClient.getProperties().getBlobSize());
            }
            BlobInputStreamOptions options = new BlobInputStreamOptions().setRange(new BlobRange(this.length.orElseThrow() - (long)bufferLength)).setBlockSize(Integer.valueOf(this.readBlockSize));
            BlobInputStream blobInputStream = this.blobClient.openInputStream(options);
            try {
                n = blobInputStream.readNBytes(buffer, bufferOffset, bufferLength);
                if (blobInputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (blobInputStream != null) {
                        try {
                            blobInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw AzureUtils.handleAzureException(e, "reading file", this.location);
                }
            }
            blobInputStream.close();
        }
        return n;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }

    public void close() {
        this.closed = true;
    }

    public String toString() {
        return this.location.toString();
    }
}

