/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest.files;

import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonIgnore;
import io.trino.hadoop.$internal.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.AbstractManifestData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.EntryStatus;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public final class DirEntry
implements Serializable {
    private static final long serialVersionUID = 5658520530209859765L;
    @JsonProperty(value="d")
    private String dir;
    @JsonProperty(value="t")
    private int type;
    @JsonProperty(value="l")
    private int level;

    private DirEntry() {
    }

    public DirEntry(String dir, int type, int level) {
        this.dir = Objects.requireNonNull(dir);
        this.type = type;
        this.level = level;
    }

    public DirEntry(Path dir, int type, int level) {
        this(AbstractManifestData.marshallPath(dir), type, level);
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getDir() {
        return this.dir;
    }

    @JsonIgnore
    public Path getDestPath() {
        return AbstractManifestData.unmarshallPath(this.dir);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    @JsonIgnore
    public EntryStatus getStatus() {
        return EntryStatus.toEntryStatus(this.type);
    }

    @JsonIgnore
    public void setStatus(EntryStatus status) {
        this.setType(status.ordinal());
    }

    public void validate() throws IOException {
        String s2 = this.toString();
        AbstractManifestData.verify(this.dir != null && this.dir.length() > 0, "destination path is missing from " + s2, new Object[0]);
        AbstractManifestData.verify(this.type >= 0, "Invalid type in " + s2, new Object[0]);
        AbstractManifestData.verify(this.level >= 0, "Invalid level in " + s2, new Object[0]);
    }

    public String toString() {
        return "DirEntry{dir='" + this.dir + '\'' + ", type=" + this.type + ", level=" + this.level + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirEntry dirEntry = (DirEntry)o;
        return this.dir.equals(dirEntry.dir);
    }

    public int hashCode() {
        return Objects.hash(this.dir);
    }

    public static DirEntry dirEntry(Path dest, int type, int level) {
        return new DirEntry(dest, type, level);
    }

    public static DirEntry dirEntry(Path dest, EntryStatus type, int level) {
        return DirEntry.dirEntry(dest, type.ordinal(), level);
    }
}

