/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.protobuf.RpcController;
import io.trino.hadoop.$internal.org.apache.hadoop.thirdparty.protobuf.ServiceException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeVolumeInfo;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolServerSideUtils;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.net.NetUtils;

@InterfaceAudience.Private
public class ClientDatanodeProtocolServerSideTranslatorPB
implements ClientDatanodeProtocolPB {
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto REFRESH_NAMENODE_RESP = ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto DELETE_BLOCKPOOL_RESP = ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto SHUTDOWN_DATANODE_RESP = ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.StartReconfigurationResponseProto START_RECONFIG_RESP = ReconfigurationProtocolProtos.StartReconfigurationResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto TRIGGER_BLOCK_REPORT_RESP = ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.EvictWritersResponseProto EVICT_WRITERS_RESP = ClientDatanodeProtocolProtos.EvictWritersResponseProto.newBuilder().build();
    private final ClientDatanodeProtocol impl;

    public ClientDatanodeProtocolServerSideTranslatorPB(ClientDatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto getReplicaVisibleLength(RpcController unused, ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto request) throws ServiceException {
        long len;
        try {
            len = this.impl.getReplicaVisibleLength(PBHelperClient.convert(request.getBlock()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto.newBuilder().setLength(len).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto refreshNamenodes(RpcController unused, ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto request) throws ServiceException {
        try {
            this.impl.refreshNamenodes();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return REFRESH_NAMENODE_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto deleteBlockPool(RpcController unused, ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto request) throws ServiceException {
        try {
            this.impl.deleteBlockPool(request.getBlockPool(), request.getForce());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return DELETE_BLOCKPOOL_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto getBlockLocalPathInfo(RpcController unused, ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto request) throws ServiceException {
        BlockLocalPathInfo resp;
        try {
            resp = this.impl.getBlockLocalPathInfo(PBHelperClient.convert(request.getBlock()), PBHelperClient.convert(request.getToken()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto.newBuilder().setBlock(PBHelperClient.convert(resp.getBlock())).setLocalPath(resp.getBlockPath()).setLocalMetaPath(resp.getMetaPath()).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto shutdownDatanode(RpcController unused, ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto request) throws ServiceException {
        try {
            this.impl.shutdownDatanode(request.getForUpgrade());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return SHUTDOWN_DATANODE_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.EvictWritersResponseProto evictWriters(RpcController unused, ClientDatanodeProtocolProtos.EvictWritersRequestProto request) throws ServiceException {
        try {
            this.impl.evictWriters();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return EVICT_WRITERS_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto getDatanodeInfo(RpcController unused, ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto request) throws ServiceException {
        ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto res;
        try {
            res = ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto.newBuilder().setLocalInfo(PBHelperClient.convert(this.impl.getDatanodeInfo())).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return res;
    }

    @Override
    public ReconfigurationProtocolProtos.StartReconfigurationResponseProto startReconfiguration(RpcController unused, ReconfigurationProtocolProtos.StartReconfigurationRequestProto request) throws ServiceException {
        try {
            this.impl.startReconfiguration();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return START_RECONFIG_RESP;
    }

    @Override
    public ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto listReconfigurableProperties(RpcController controller, ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto request) throws ServiceException {
        try {
            return ReconfigurationProtocolServerSideUtils.listReconfigurableProperties(this.impl.listReconfigurableProperties());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto getReconfigurationStatus(RpcController unused, ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto request) throws ServiceException {
        try {
            return ReconfigurationProtocolServerSideUtils.getReconfigurationStatus(this.impl.getReconfigurationStatus());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto triggerBlockReport(RpcController unused, ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto request) throws ServiceException {
        try {
            BlockReportOptions.Factory factory = new BlockReportOptions.Factory().setIncremental(request.getIncremental());
            if (request.hasNnAddress()) {
                factory.setNamenodeAddr(NetUtils.createSocketAddr(request.getNnAddress()));
            }
            this.impl.triggerBlockReport(factory.build());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return TRIGGER_BLOCK_REPORT_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto getBalancerBandwidth(RpcController controller, ClientDatanodeProtocolProtos.GetBalancerBandwidthRequestProto request) throws ServiceException {
        long bandwidth;
        try {
            bandwidth = this.impl.getBalancerBandwidth();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetBalancerBandwidthResponseProto.newBuilder().setBandwidth(bandwidth).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanResponseProto submitDiskBalancerPlan(RpcController controller, ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanRequestProto request) throws ServiceException {
        try {
            this.impl.submitDiskBalancerPlan(request.getPlanID(), request.hasPlanVersion() ? request.getPlanVersion() : 1L, request.hasPlanFile() ? request.getPlanFile() : "", request.getPlan(), request.hasIgnoreDateCheck() ? request.getIgnoreDateCheck() : false);
            ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanResponseProto response = ClientDatanodeProtocolProtos.SubmitDiskBalancerPlanResponseProto.newBuilder().build();
            return response;
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ClientDatanodeProtocolProtos.CancelPlanResponseProto cancelDiskBalancerPlan(RpcController controller, ClientDatanodeProtocolProtos.CancelPlanRequestProto request) throws ServiceException {
        try {
            this.impl.cancelDiskBalancePlan(request.getPlanID());
            return ClientDatanodeProtocolProtos.CancelPlanResponseProto.newBuilder().build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ClientDatanodeProtocolProtos.QueryPlanStatusResponseProto queryDiskBalancerPlan(RpcController controller, ClientDatanodeProtocolProtos.QueryPlanStatusRequestProto request) throws ServiceException {
        try {
            DiskBalancerWorkStatus result = this.impl.queryDiskBalancerPlan();
            return ClientDatanodeProtocolProtos.QueryPlanStatusResponseProto.newBuilder().setResult(result.getResult().getIntResult()).setPlanID(result.getPlanID()).setPlanFile(result.getPlanFile()).setCurrentStatus(result.currentStateString()).build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ClientDatanodeProtocolProtos.DiskBalancerSettingResponseProto getDiskBalancerSetting(RpcController controller, ClientDatanodeProtocolProtos.DiskBalancerSettingRequestProto request) throws ServiceException {
        try {
            String val = this.impl.getDiskBalancerSetting(request.getKey());
            return ClientDatanodeProtocolProtos.DiskBalancerSettingResponseProto.newBuilder().setValue(val).build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Override
    public ClientDatanodeProtocolProtos.GetVolumeReportResponseProto getVolumeReport(RpcController controller, ClientDatanodeProtocolProtos.GetVolumeReportRequestProto request) throws ServiceException {
        try {
            ClientDatanodeProtocolProtos.GetVolumeReportResponseProto.Builder builder = ClientDatanodeProtocolProtos.GetVolumeReportResponseProto.newBuilder();
            List<DatanodeVolumeInfo> volumeReport = this.impl.getVolumeReport();
            for (DatanodeVolumeInfo info : volumeReport) {
                builder.addVolumeInfo(HdfsProtos.DatanodeVolumeInfoProto.newBuilder().setPath(info.getPath()).setFreeSpace(info.getFreeSpace()).setNumBlocks(info.getNumBlocks()).setReservedSpace(info.getReservedSpace()).setReservedSpaceForReplicas(info.getReservedSpaceForReplicas()).setStorageType(PBHelperClient.convertStorageType(info.getStorageType())).setUsedSpace(info.getUsedSpace()));
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }
}

