/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import io.trino.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.RequestResult;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.ResponseReceivedEvent;
import io.trino.hadoop.$internal.com.microsoft.azure.storage.StorageEvent;
import io.trino.hadoop.$internal.org.apache.commons.logging.Log;
import io.trino.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.net.HttpURLConnection;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azure.metrics.BandwidthGaugeUpdater;

@InterfaceAudience.Private
public final class ResponseReceivedMetricUpdater
extends StorageEvent<ResponseReceivedEvent> {
    public static final Log LOG = LogFactory.getLog(ResponseReceivedMetricUpdater.class);
    private final AzureFileSystemInstrumentation instrumentation;
    private final BandwidthGaugeUpdater blockUploadGaugeUpdater;

    private ResponseReceivedMetricUpdater(OperationContext operationContext, AzureFileSystemInstrumentation instrumentation, BandwidthGaugeUpdater blockUploadGaugeUpdater) {
        this.instrumentation = instrumentation;
        this.blockUploadGaugeUpdater = blockUploadGaugeUpdater;
    }

    public static void hook(OperationContext operationContext, AzureFileSystemInstrumentation instrumentation, BandwidthGaugeUpdater blockUploadGaugeUpdater) {
        ResponseReceivedMetricUpdater listener = new ResponseReceivedMetricUpdater(operationContext, instrumentation, blockUploadGaugeUpdater);
        operationContext.getResponseReceivedEventHandler().addListener(listener);
    }

    private long getRequestContentLength(HttpURLConnection connection) {
        String lengthString = connection.getRequestProperty("Content-Length");
        if (lengthString != null) {
            return Long.parseLong(lengthString);
        }
        return 0L;
    }

    private long getResponseContentLength(HttpURLConnection connection) {
        return connection.getContentLength();
    }

    @Override
    public void eventOccurred(ResponseReceivedEvent eventArg) {
        long length;
        this.instrumentation.webResponse();
        if (!(eventArg.getConnectionObject() instanceof HttpURLConnection)) {
            return;
        }
        HttpURLConnection connection = (HttpURLConnection)eventArg.getConnectionObject();
        RequestResult currentResult = eventArg.getRequestResult();
        if (currentResult == null) {
            return;
        }
        long requestLatency = currentResult.getStopDate().getTime() - currentResult.getStartDate().getTime();
        if (currentResult.getStatusCode() == 201 && connection.getRequestMethod().equalsIgnoreCase("PUT")) {
            long length2 = this.getRequestContentLength(connection);
            if (length2 > 0L) {
                this.blockUploadGaugeUpdater.blockUploaded(currentResult.getStartDate(), currentResult.getStopDate(), length2);
                this.instrumentation.rawBytesUploaded(length2);
                this.instrumentation.blockUploaded(requestLatency);
            }
        } else if (currentResult.getStatusCode() == 206 && connection.getRequestMethod().equalsIgnoreCase("GET") && (length = this.getResponseContentLength(connection)) > 0L) {
            this.blockUploadGaugeUpdater.blockDownloaded(currentResult.getStartDate(), currentResult.getStopDate(), length);
            this.instrumentation.rawBytesDownloaded(length);
            this.instrumentation.blockDownloaded(requestLatency);
        }
    }
}

