/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.type;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public class DecodedTimestamp {
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final long epochSeconds;
    private final int nanosOfSecond;

    public DecodedTimestamp(long epochSeconds, int nanosOfSecond) {
        Preconditions.checkArgument((nanosOfSecond >= 0 && (long)nanosOfSecond < NANOS_PER_SECOND ? 1 : 0) != 0, (String)"Invalid value for nanosOfSecond: %s", (int)nanosOfSecond);
        this.epochSeconds = epochSeconds;
        this.nanosOfSecond = nanosOfSecond;
    }

    public long getEpochSeconds() {
        return this.epochSeconds;
    }

    public int getNanosOfSecond() {
        return this.nanosOfSecond;
    }
}

