/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.airlift.log.Level;
import java.time.Instant;
import java.util.Objects;

public class JsonRecord {
    private final Instant timestamp;
    private final Level level;
    private final String thread;
    private final String loggerName;
    private final String message;
    private final Throwable throwable;

    @JsonCreator
    public JsonRecord(@JsonProperty(value="timestamp") Instant timestamp, @JsonProperty(value="level") Level level, @JsonProperty(value="thread") String thread, @JsonProperty(value="logger") String loggerName, @JsonProperty(value="message") String message, Throwable throwable) {
        this.timestamp = Objects.requireNonNull(timestamp);
        this.level = Objects.requireNonNull(level);
        this.thread = thread;
        this.loggerName = loggerName;
        this.message = message;
        this.throwable = throwable;
    }

    @JsonProperty
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty
    public String getThread() {
        return this.thread;
    }

    @JsonProperty(value="logger")
    public String getLoggerName() {
        return this.loggerName;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public String getThrowableClass() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getClass().getName();
    }

    @JsonProperty
    public String getThrowableMessage() {
        if (this.throwable == null) {
            return null;
        }
        return this.throwable.getMessage();
    }

    @JsonProperty
    public String getStackTrace() {
        if (this.throwable == null) {
            return null;
        }
        return Throwables.getStackTraceAsString((Throwable)this.throwable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("timestamp", (Object)this.timestamp).add("level", (Object)this.level).add("thread", (Object)this.thread).add("loggerName", (Object)this.loggerName).add("message", (Object)this.message).add("throwable", (Object)this.throwable).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRecord that = (JsonRecord)o;
        return Objects.equals(this.timestamp, that.timestamp) && this.level == that.level && Objects.equals(this.thread, that.thread) && Objects.equals(this.loggerName, that.loggerName) && Objects.equals(this.message, that.message) && Objects.equals(this.throwable, that.throwable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.level, this.thread, this.loggerName, this.message, this.throwable});
    }
}

