/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.discovery.zen.ElectMasterService;
import org.elasticsearch.discovery.zen.MasterFaultDetection;
import org.elasticsearch.discovery.zen.MembershipAction;
import org.elasticsearch.discovery.zen.NodeJoinController;
import org.elasticsearch.discovery.zen.NodesFaultDetection;
import org.elasticsearch.discovery.zen.PendingClusterStatesQueue;
import org.elasticsearch.discovery.zen.PingContextProvider;
import org.elasticsearch.discovery.zen.PublishClusterStateAction;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.UnicastZenPing;
import org.elasticsearch.discovery.zen.ZenPing;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class ZenDiscovery
extends AbstractLifecycleComponent
implements Discovery,
PingContextProvider,
PublishClusterStateAction.IncomingClusterStateListener {
    private static final Logger logger = LogManager.getLogger(ZenDiscovery.class);
    public static final Setting<TimeValue> PING_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.zen.ping_timeout", TimeValue.timeValueSeconds((long)3L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> JOIN_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.join_timeout", settings -> TimeValue.timeValueMillis((long)(PING_TIMEOUT_SETTING.get((Settings)settings).millis() * 20L)), TimeValue.timeValueMillis((long)0L), Setting.Property.NodeScope);
    public static final Setting<Integer> JOIN_RETRY_ATTEMPTS_SETTING = Setting.intSetting("discovery.zen.join_retry_attempts", 3, 1, Setting.Property.NodeScope);
    public static final Setting<TimeValue> JOIN_RETRY_DELAY_SETTING = Setting.positiveTimeSetting("discovery.zen.join_retry_delay", TimeValue.timeValueMillis((long)100L), Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_PINGS_FROM_ANOTHER_MASTER_SETTING = Setting.intSetting("discovery.zen.max_pings_from_another_master", 3, 1, Setting.Property.NodeScope);
    public static final Setting<Boolean> SEND_LEAVE_REQUEST_SETTING = Setting.boolSetting("discovery.zen.send_leave_request", true, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MASTER_ELECTION_WAIT_FOR_JOINS_TIMEOUT_SETTING = Setting.timeSetting("discovery.zen.master_election.wait_for_joins_timeout", settings -> TimeValue.timeValueMillis((long)(JOIN_TIMEOUT_SETTING.get((Settings)settings).millis() / 2L)), TimeValue.timeValueMillis((long)0L), Setting.Property.NodeScope);
    public static final Setting<Boolean> MASTER_ELECTION_IGNORE_NON_MASTER_PINGS_SETTING = Setting.boolSetting("discovery.zen.master_election.ignore_non_master_pings", false, Setting.Property.NodeScope);
    public static final Setting<Integer> MAX_PENDING_CLUSTER_STATES_SETTING = Setting.intSetting("discovery.zen.publish.max_pending_cluster_states", 25, 1, Setting.Property.NodeScope);
    public static final String DISCOVERY_REJOIN_ACTION_NAME = "internal:discovery/zen/rejoin";
    private final TransportService transportService;
    private final MasterService masterService;
    private final DiscoverySettings discoverySettings;
    protected final ZenPing zenPing;
    private final MasterFaultDetection masterFD;
    private final NodesFaultDetection nodesFD;
    private final PublishClusterStateAction publishClusterState;
    private final MembershipAction membership;
    private final ClusterName clusterName;
    private final ThreadPool threadPool;
    private final TimeValue pingTimeout;
    private final TimeValue joinTimeout;
    private final int joinRetryAttempts;
    private final TimeValue joinRetryDelay;
    private final int maxPingsFromAnotherMaster;
    private final boolean sendLeaveRequest;
    private final ElectMasterService electMaster;
    private final boolean masterElectionIgnoreNonMasters;
    private final TimeValue masterElectionWaitForJoinsTimeout;
    private final JoinThreadControl joinThreadControl;
    private final PendingClusterStatesQueue pendingStatesQueue;
    private final NodeJoinController nodeJoinController;
    private final NodeRemovalClusterStateTaskExecutor nodeRemovalExecutor;
    private final ClusterApplier clusterApplier;
    private final AtomicReference<ClusterState> committedState;
    private final Object stateMutex = new Object();
    private final Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators;

    public ZenDiscovery(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, UnicastHostsProvider hostsProvider, AllocationService allocationService, Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators) {
        this.onJoinValidators = ZenDiscovery.addBuiltInJoinValidators(onJoinValidators);
        this.masterService = masterService;
        this.clusterApplier = clusterApplier;
        this.transportService = transportService;
        this.discoverySettings = new DiscoverySettings(settings, clusterSettings);
        this.zenPing = this.newZenPing(settings, threadPool, transportService, hostsProvider);
        this.electMaster = new ElectMasterService(settings);
        this.pingTimeout = PING_TIMEOUT_SETTING.get(settings);
        this.joinTimeout = JOIN_TIMEOUT_SETTING.get(settings);
        this.joinRetryAttempts = JOIN_RETRY_ATTEMPTS_SETTING.get(settings);
        this.joinRetryDelay = JOIN_RETRY_DELAY_SETTING.get(settings);
        this.maxPingsFromAnotherMaster = MAX_PINGS_FROM_ANOTHER_MASTER_SETTING.get(settings);
        this.sendLeaveRequest = SEND_LEAVE_REQUEST_SETTING.get(settings);
        this.threadPool = threadPool;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.committedState = new AtomicReference();
        this.masterElectionIgnoreNonMasters = MASTER_ELECTION_IGNORE_NON_MASTER_PINGS_SETTING.get(settings);
        this.masterElectionWaitForJoinsTimeout = MASTER_ELECTION_WAIT_FOR_JOINS_TIMEOUT_SETTING.get(settings);
        logger.debug("using ping_timeout [{}], join.timeout [{}], master_election.ignore_non_master [{}]", (Object)this.pingTimeout, (Object)this.joinTimeout, (Object)this.masterElectionIgnoreNonMasters);
        clusterSettings.addSettingsUpdateConsumer(ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING, this::handleMinimumMasterNodesChanged, value -> {
            ClusterState clusterState = this.clusterState();
            int masterNodes = clusterState.nodes().getMasterNodes().size();
            if (clusterState.nodes().isLocalNodeElectedMaster() && value > masterNodes) {
                throw new IllegalArgumentException("cannot set " + ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.getKey() + " to more than the current master nodes count [" + masterNodes + "]");
            }
        });
        this.masterFD = new MasterFaultDetection(settings, threadPool, transportService, this::clusterState, masterService, this.clusterName);
        this.masterFD.addListener(new MasterNodeFailureListener());
        this.nodesFD = new NodesFaultDetection(settings, threadPool, transportService, this::clusterState, this.clusterName);
        this.nodesFD.addListener(new NodeFaultDetectionListener());
        this.pendingStatesQueue = new PendingClusterStatesQueue(logger, MAX_PENDING_CLUSTER_STATES_SETTING.get(settings));
        this.publishClusterState = new PublishClusterStateAction(transportService, namedWriteableRegistry, this, this.discoverySettings);
        this.membership = new MembershipAction(transportService, new MembershipListener(), onJoinValidators);
        this.joinThreadControl = new JoinThreadControl();
        this.nodeJoinController = new NodeJoinController(settings, masterService, allocationService, this.electMaster);
        this.nodeRemovalExecutor = new NodeRemovalClusterStateTaskExecutor(allocationService, this.electMaster, this::submitRejoin, logger);
        masterService.setClusterStateSupplier(this::clusterState);
        transportService.registerRequestHandler(DISCOVERY_REJOIN_ACTION_NAME, RejoinClusterRequest::new, "same", new RejoinClusterRequestHandler());
    }

    static Collection<BiConsumer<DiscoveryNode, ClusterState>> addBuiltInJoinValidators(Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> validators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        validators.add((node, state) -> {
            MembershipAction.ensureNodesCompatibility(node.getVersion(), state.getNodes());
            MembershipAction.ensureIndexCompatibility(node.getVersion(), state.getMetaData());
        });
        validators.addAll(onJoinValidators);
        return Collections.unmodifiableCollection(validators);
    }

    protected ZenPing newZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, UnicastHostsProvider hostsProvider) {
        return new UnicastZenPing(settings, threadPool, transportService, hostsProvider, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (localNode != null);
        Object object = this.stateMutex;
        synchronized (object) {
            assert (this.committedState.get() == null);
            assert (localNode != null);
            ClusterState.Builder builder = this.clusterApplier.newClusterStateBuilder();
            ClusterState initialState = builder.blocks(ClusterBlocks.builder().addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).addGlobalBlock(this.discoverySettings.getNoMasterBlock())).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId())).build();
            this.committedState.set(initialState);
            this.clusterApplier.setInitialState(initialState);
            this.nodesFD.setLocalNode(localNode);
            this.joinThreadControl.start();
        }
        this.zenPing.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startInitialJoin() {
        Object object = this.stateMutex;
        synchronized (object) {
            this.joinThreadControl.startNewThreadIfNotRunning();
        }
    }

    @Override
    protected void doStop() {
        this.joinThreadControl.stop();
        this.masterFD.stop("zen disco stop");
        this.nodesFD.stop();
        Releasables.close(this.zenPing);
        DiscoveryNodes nodes = this.clusterState().nodes();
        if (this.sendLeaveRequest && nodes.getMasterNode() != null) {
            if (!nodes.isLocalNodeElectedMaster()) {
                try {
                    this.membership.sendLeaveRequestBlocking(nodes.getMasterNode(), nodes.getLocalNode(), TimeValue.timeValueSeconds((long)1L));
                }
                catch (Exception e) {
                    logger.debug(() -> new ParameterizedMessage("failed to send leave request to master [{}]", (Object)nodes.getMasterNode()), (Throwable)e);
                }
            } else {
                DiscoveryNode[] possibleMasters;
                for (DiscoveryNode possibleMaster : possibleMasters = this.electMaster.nextPossibleMasters(nodes.getNodes().values(), 5)) {
                    if (nodes.getLocalNode().equals(possibleMaster)) continue;
                    try {
                        this.membership.sendLeaveRequest(nodes.getLocalNode(), possibleMaster);
                    }
                    catch (Exception e) {
                        logger.debug(() -> new ParameterizedMessage("failed to send leave request from master [{}] to possible master [{}]", (Object)nodes.getMasterNode(), (Object)possibleMaster), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    protected void doClose() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.masterFD, this.nodesFD});
    }

    @Override
    public ClusterState clusterState() {
        ClusterState clusterState = this.committedState.get();
        assert (clusterState != null) : "accessing cluster state before it is set";
        return clusterState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(final ClusterChangedEvent clusterChangedEvent, final Discovery.AckListener ackListener) {
        ClusterState newState = clusterChangedEvent.state();
        assert (newState.getNodes().isLocalNodeElectedMaster()) : "Shouldn't publish state when not master " + clusterChangedEvent.source();
        if (clusterChangedEvent.previousState() != this.committedState.get()) {
            throw new Discovery.FailedToCommitClusterStateException("state was mutated while calculating new CS update", new Object[0]);
        }
        this.pendingStatesQueue.addPending(newState);
        try {
            this.publishClusterState.publish(clusterChangedEvent, this.electMaster.minimumMasterNodes(), ackListener);
        }
        catch (Discovery.FailedToCommitClusterStateException t) {
            logger.debug("failed to publish cluster state version [{}] (not enough nodes acknowledged, min master nodes [{}])", (Object)newState.version(), (Object)this.electMaster.minimumMasterNodes());
            Object object = this.stateMutex;
            synchronized (object) {
                this.pendingStatesQueue.failAllStatesAndClear(new ElasticsearchException("failed to publish cluster state", new Object[0]));
                this.rejoin("zen-disco-failed-to-publish");
            }
            throw t;
        }
        final DiscoveryNode localNode = newState.getNodes().getLocalNode();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicBoolean processedOrFailed = new AtomicBoolean();
        this.pendingStatesQueue.markAsCommitted(newState.stateUUID(), new PendingClusterStatesQueue.StateProcessedListener(){

            @Override
            public void onNewClusterStateProcessed() {
                processedOrFailed.set(true);
                latch.countDown();
                ackListener.onNodeAck(localNode, null);
            }

            @Override
            public void onNewClusterStateFailed(Exception e) {
                processedOrFailed.set(true);
                latch.countDown();
                ackListener.onNodeAck(localNode, e);
                logger.warn(() -> new ParameterizedMessage("failed while applying cluster state locally [{}]", (Object)clusterChangedEvent.source()), (Throwable)e);
            }
        });
        Object object = this.stateMutex;
        synchronized (object) {
            if (clusterChangedEvent.previousState() != this.committedState.get()) {
                throw new Discovery.FailedToCommitClusterStateException("local state was mutated while CS update was published to other nodes", new Object[0]);
            }
            boolean sentToApplier = this.processNextCommittedClusterState("master " + newState.nodes().getMasterNode() + " committed version [" + newState.version() + "] source [" + clusterChangedEvent.source() + "]");
            if (!sentToApplier && !processedOrFailed.get()) {
                assert (false) : "cluster state published locally neither processed nor failed: " + newState;
                logger.warn("cluster state with version [{}] that is published locally has neither been processed nor failed", (Object)newState.version());
                return;
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            logger.debug(() -> new ParameterizedMessage("interrupted while applying cluster state locally [{}]", (Object)clusterChangedEvent.source()), (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    Set<DiscoveryNode> getFaultDetectionNodes() {
        return this.nodesFD.getNodes();
    }

    @Override
    public DiscoveryStats stats() {
        return new DiscoveryStats(this.pendingStatesQueue.stats(), this.publishClusterState.stats());
    }

    public DiscoverySettings getDiscoverySettings() {
        return this.discoverySettings;
    }

    public boolean joiningCluster() {
        return this.joinThreadControl.joinThreadActive();
    }

    public ClusterState[] pendingClusterStates() {
        return this.pendingStatesQueue.pendingClusterStates();
    }

    PendingClusterStatesQueue pendingClusterStatesQueue() {
        return this.pendingStatesQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerJoinCluster() {
        DiscoveryNode masterNode = null;
        final Thread currentThread = Thread.currentThread();
        this.nodeJoinController.startElectionContext();
        while (masterNode == null && this.joinThreadControl.joinThreadActive(currentThread)) {
            masterNode = this.findMaster();
        }
        if (!this.joinThreadControl.joinThreadActive(currentThread)) {
            logger.trace("thread is no longer in currentJoinThread. Stopping.");
            return;
        }
        if (this.transportService.getLocalNode().equals(masterNode)) {
            int requiredJoins = Math.max(0, this.electMaster.minimumMasterNodes() - 1);
            logger.debug("elected as master, waiting for incoming joins ([{}] needed)", (Object)requiredJoins);
            this.nodeJoinController.waitToBeElectedAsMaster(requiredJoins, this.masterElectionWaitForJoinsTimeout, new NodeJoinController.ElectionCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onElectedAsMaster(ClusterState state) {
                    Object object = ZenDiscovery.this.stateMutex;
                    synchronized (object) {
                        ZenDiscovery.this.joinThreadControl.markThreadAsDone(currentThread);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Throwable t) {
                    logger.trace("failed while waiting for nodes to join, rejoining", t);
                    Object object = ZenDiscovery.this.stateMutex;
                    synchronized (object) {
                        ZenDiscovery.this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                    }
                }
            });
        } else {
            this.nodeJoinController.stopElectionContext(masterNode + " elected");
            boolean success = this.joinElectedMaster(masterNode);
            Object object = this.stateMutex;
            synchronized (object) {
                if (success) {
                    DiscoveryNode currentMasterNode = this.clusterState().getNodes().getMasterNode();
                    if (currentMasterNode == null) {
                        logger.debug("no master node is set, despite of join request completing. retrying pings.");
                        this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                    } else if (!currentMasterNode.equals(masterNode)) {
                        this.joinThreadControl.stopRunningThreadAndRejoin("master_switched_while_finalizing_join");
                    }
                    this.joinThreadControl.markThreadAsDone(currentThread);
                } else {
                    this.joinThreadControl.markThreadAsDoneAndStartNew(currentThread);
                }
            }
        }
    }

    private boolean joinElectedMaster(DiscoveryNode masterNode) {
        try {
            this.transportService.connectToNode(masterNode);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("failed to connect to master [{}], retrying...", (Object)masterNode), (Throwable)e);
            return false;
        }
        int joinAttempt = 0;
        while (true) {
            try {
                logger.trace("joining master {}", (Object)masterNode);
                this.membership.sendJoinRequestBlocking(masterNode, this.transportService.getLocalNode(), this.joinTimeout);
                return true;
            }
            catch (Exception e) {
                Throwable unwrap = ExceptionsHelper.unwrapCause(e);
                if (unwrap instanceof NotMasterException) {
                    if (++joinAttempt == this.joinRetryAttempts) {
                        logger.info("failed to send join request to master [{}], reason [{}], tried [{}] times", (Object)masterNode, (Object)ExceptionsHelper.detailedMessage(e), (Object)joinAttempt);
                        return false;
                    }
                } else {
                    if (logger.isTraceEnabled()) {
                        logger.trace(() -> new ParameterizedMessage("failed to send join request to master [{}]", (Object)masterNode), (Throwable)e);
                    } else {
                        logger.info("failed to send join request to master [{}], reason [{}]", (Object)masterNode, (Object)ExceptionsHelper.detailedMessage(e));
                    }
                    return false;
                }
                logger.trace("master {} failed with [{}]. retrying... (attempts done: [{}])", (Object)masterNode, (Object)ExceptionsHelper.detailedMessage(e), (Object)joinAttempt);
                try {
                    Thread.sleep(this.joinRetryDelay.millis());
                    continue;
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitRejoin(String source) {
        Object object = this.stateMutex;
        synchronized (object) {
            this.rejoin(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCommittedState(ClusterState clusterState) {
        Object object = this.stateMutex;
        synchronized (object) {
            this.committedState.set(clusterState);
        }
    }

    private void removeNode(DiscoveryNode node, String source, String reason) {
        this.masterService.submitStateUpdateTask(source + "(" + node + "), reason(" + reason + ")", new NodeRemovalClusterStateTaskExecutor.Task(node, reason), ClusterStateTaskConfig.build(Priority.IMMEDIATE), this.nodeRemovalExecutor, this.nodeRemovalExecutor);
    }

    private void handleLeaveRequest(DiscoveryNode node) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.localNodeMaster()) {
            this.removeNode(node, "zen-disco-node-left", "left");
        } else if (node.equals(this.clusterState().nodes().getMasterNode())) {
            this.handleMasterGone(node, null, "shut_down");
        }
    }

    private void handleNodeFailure(DiscoveryNode node, String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (!this.localNodeMaster()) {
            return;
        }
        this.removeNode(node, "zen-disco-node-failed", reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMinimumMasterNodesChanged(int minimumMasterNodes) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        int prevMinimumMasterNode = this.electMaster.minimumMasterNodes();
        this.electMaster.minimumMasterNodes(minimumMasterNodes);
        if (!this.localNodeMaster()) {
            return;
        }
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.electMaster.hasEnoughMasterNodes(this.committedState.get().nodes())) {
                this.rejoin("not enough master nodes on change of minimum_master_nodes from [" + prevMinimumMasterNode + "] to [" + minimumMasterNodes + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMasterGone(DiscoveryNode masterNode, Throwable cause, String reason) {
        if (this.lifecycleState() != Lifecycle.State.STARTED) {
            return;
        }
        if (this.localNodeMaster()) {
            return;
        }
        logger.info(() -> new ParameterizedMessage("master_left [{}], reason [{}]", (Object)masterNode, (Object)reason), cause);
        Object object = this.stateMutex;
        synchronized (object) {
            if (!this.localNodeMaster() && masterNode.equals(this.committedState.get().nodes().getMasterNode())) {
                this.pendingStatesQueue.failAllStatesAndClear(new ElasticsearchException("master left [{}]", reason));
                this.rejoin("master left (reason = " + reason + ")");
            }
        }
    }

    boolean processNextCommittedClusterState(final String reason) {
        assert (Thread.holdsLock(this.stateMutex));
        final ClusterState newClusterState = this.pendingStatesQueue.getNextClusterStateToProcess();
        ClusterState currentState = this.committedState.get();
        if (newClusterState == null) {
            return false;
        }
        assert (newClusterState.nodes().getMasterNode() != null) : "received a cluster state without a master";
        assert (!newClusterState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock())) : "received a cluster state with a master block";
        if (currentState.nodes().isLocalNodeElectedMaster() && !newClusterState.nodes().isLocalNodeElectedMaster()) {
            this.handleAnotherMaster(currentState, newClusterState.nodes().getMasterNode(), newClusterState.version(), "via a new cluster state");
            return false;
        }
        try {
            if (ZenDiscovery.shouldIgnoreOrRejectNewClusterState(logger, currentState, newClusterState)) {
                String message = String.format(Locale.ROOT, "rejecting cluster state version [%d] uuid [%s] received from [%s]", newClusterState.version(), newClusterState.stateUUID(), newClusterState.nodes().getMasterNodeId());
                throw new IllegalStateException(message);
            }
        }
        catch (Exception e) {
            try {
                this.pendingStatesQueue.markAsFailed(newClusterState, e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error(() -> new ParameterizedMessage("unexpected exception while failing [{}]", (Object)reason), (Throwable)inner);
            }
            return false;
        }
        if (currentState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock())) {
            logger.debug("got first state from fresh master [{}]", (Object)newClusterState.nodes().getMasterNodeId());
        }
        if (currentState == newClusterState) {
            return false;
        }
        this.committedState.set(newClusterState);
        if (newClusterState.nodes().isLocalNodeElectedMaster()) {
            this.nodesFD.updateNodesAndPing(newClusterState);
        } else if (this.masterFD.masterNode() == null || !this.masterFD.masterNode().equals(newClusterState.nodes().getMasterNode())) {
            this.masterFD.restart(newClusterState.nodes().getMasterNode(), "new cluster state received and we are monitoring the wrong master [" + this.masterFD.masterNode() + "]");
        }
        this.clusterApplier.onNewClusterState("apply cluster state (from master [" + reason + "])", this::clusterState, new ClusterApplier.ClusterApplyListener(){

            @Override
            public void onSuccess(String source) {
                try {
                    ZenDiscovery.this.pendingStatesQueue.markAsProcessed(newClusterState);
                }
                catch (Exception e) {
                    this.onFailure(source, e);
                }
            }

            @Override
            public void onFailure(String source, Exception e) {
                logger.error(() -> new ParameterizedMessage("unexpected failure applying [{}]", (Object)reason), (Throwable)e);
                try {
                    ZenDiscovery.this.pendingStatesQueue.markAsFailed(newClusterState, e);
                }
                catch (Exception inner) {
                    inner.addSuppressed(e);
                    logger.error(() -> new ParameterizedMessage("unexpected exception while failing [{}]", (Object)reason), (Throwable)inner);
                }
            }
        });
        return true;
    }

    public static boolean shouldIgnoreOrRejectNewClusterState(Logger logger, ClusterState currentState, ClusterState newClusterState) {
        ZenDiscovery.validateStateIsFromCurrentMaster(logger, currentState.nodes(), newClusterState);
        if (currentState.supersedes(newClusterState) || newClusterState.nodes().getMasterNodeId().equals(currentState.nodes().getMasterNodeId()) && currentState.version() == newClusterState.version()) {
            logger.debug("received a cluster state that is not newer than the current one, ignoring (received {}, current {})", (Object)newClusterState.version(), (Object)currentState.version());
            return true;
        }
        if (currentState.nodes().getMasterNodeId() != null && newClusterState.version() < currentState.version()) {
            logger.debug("received a cluster state that has a lower version than the current one, ignoring (received {}, current {})", (Object)newClusterState.version(), (Object)currentState.version());
            return true;
        }
        return false;
    }

    public static void validateStateIsFromCurrentMaster(Logger logger, DiscoveryNodes currentNodes, ClusterState newClusterState) {
        if (currentNodes.getMasterNodeId() == null) {
            return;
        }
        if (!currentNodes.getMasterNodeId().equals(newClusterState.nodes().getMasterNodeId())) {
            logger.warn("received a cluster state from a different master than the current one, rejecting (received {}, current {})", (Object)newClusterState.nodes().getMasterNode(), (Object)currentNodes.getMasterNode());
            throw new IllegalStateException("cluster state from a different master than the current one, rejecting (received " + newClusterState.nodes().getMasterNode() + ", current " + currentNodes.getMasterNode() + ")");
        }
    }

    void handleJoinRequest(DiscoveryNode node, ClusterState state, MembershipAction.JoinCallback callback) {
        if (this.nodeJoinController == null) {
            throw new IllegalStateException("discovery module is not yet started");
        }
        this.onJoinValidators.stream().forEach(a -> a.accept(node, state));
        if (!state.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            MembershipAction.ensureMajorVersionBarrier(node.getVersion(), state.getNodes().getMinNodeVersion());
        }
        this.transportService.connectToNode(node);
        try {
            this.membership.sendValidateJoinRequestBlocking(node, state, this.joinTimeout);
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("failed to validate incoming join request from node [{}]", (Object)node), (Throwable)e);
            callback.onFailure(new IllegalStateException("failure when sending a validation request to node", e));
            return;
        }
        this.nodeJoinController.handleJoinRequest(node, callback);
    }

    private DiscoveryNode findMaster() {
        logger.trace("starting to ping");
        List<ZenPing.PingResponse> fullPingResponses = this.pingAndWait(this.pingTimeout).toList();
        if (fullPingResponses == null) {
            logger.trace("No full ping responses");
            return null;
        }
        if (logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (fullPingResponses.size() == 0) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : fullPingResponses) {
                    sb.append("\n\t--> ").append(pingResponse);
                }
            }
            logger.trace("full ping responses:{}", (Object)sb);
        }
        DiscoveryNode localNode = this.transportService.getLocalNode();
        assert (!fullPingResponses.stream().map(ZenPing.PingResponse::node).filter(n -> n.equals(localNode)).findAny().isPresent());
        fullPingResponses.add(new ZenPing.PingResponse(localNode, null, this.clusterState()));
        List<ZenPing.PingResponse> pingResponses = ZenDiscovery.filterPingResponses(fullPingResponses, this.masterElectionIgnoreNonMasters, logger);
        ArrayList<DiscoveryNode> activeMasters = new ArrayList<DiscoveryNode>();
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            if (pingResponse.master() == null || localNode.equals(pingResponse.master())) continue;
            activeMasters.add(pingResponse.master());
        }
        ArrayList<ElectMasterService.MasterCandidate> masterCandidates = new ArrayList<ElectMasterService.MasterCandidate>();
        for (ZenPing.PingResponse pingResponse : pingResponses) {
            if (!pingResponse.node().isMasterNode()) continue;
            masterCandidates.add(new ElectMasterService.MasterCandidate(pingResponse.node(), pingResponse.getClusterStateVersion()));
        }
        if (activeMasters.isEmpty()) {
            if (this.electMaster.hasEnoughCandidates(masterCandidates)) {
                ElectMasterService.MasterCandidate masterCandidate = this.electMaster.electMaster(masterCandidates);
                logger.trace("candidate {} won election", (Object)masterCandidate);
                return masterCandidate.getNode();
            }
            logger.warn("not enough master nodes discovered during pinging (found [{}], but needed [{}]), pinging again", masterCandidates, (Object)this.electMaster.minimumMasterNodes());
            return null;
        }
        assert (!activeMasters.contains(localNode)) : "local node should never be elected as master when other nodes indicate an active master";
        return this.electMaster.tieBreakActiveMasters(activeMasters);
    }

    static List<ZenPing.PingResponse> filterPingResponses(List<ZenPing.PingResponse> fullPingResponses, boolean masterElectionIgnoreNonMasters, Logger logger) {
        List<ZenPing.PingResponse> pingResponses = masterElectionIgnoreNonMasters ? fullPingResponses.stream().filter(ping -> ping.node().isMasterNode()).collect(Collectors.toList()) : fullPingResponses;
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (pingResponses.isEmpty()) {
                sb.append(" {none}");
            } else {
                for (ZenPing.PingResponse pingResponse : pingResponses) {
                    sb.append("\n\t--> ").append(pingResponse);
                }
            }
            logger.debug("filtered ping responses: (ignore_non_masters [{}]){}", (Object)masterElectionIgnoreNonMasters, (Object)sb);
        }
        return pingResponses;
    }

    protected void rejoin(String reason) {
        assert (Thread.holdsLock(this.stateMutex));
        ClusterState clusterState = this.committedState.get();
        logger.warn("{}, current nodes: {}", (Object)reason, (Object)clusterState.nodes());
        this.nodesFD.stop();
        this.masterFD.stop(reason);
        this.joinThreadControl.startNewThreadIfNotRunning();
        if (clusterState.nodes().getMasterNodeId() != null) {
            assert (!clusterState.blocks().hasGlobalBlockWithId(this.discoverySettings.getNoMasterBlock().id())) : "NO_MASTER_BLOCK should only be added by ZenDiscovery";
            ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(clusterState.blocks()).addGlobalBlock(this.discoverySettings.getNoMasterBlock()).build();
            DiscoveryNodes discoveryNodes = new DiscoveryNodes.Builder(clusterState.nodes()).masterNodeId(null).build();
            clusterState = ClusterState.builder(clusterState).blocks(clusterBlocks).nodes(discoveryNodes).build();
            this.committedState.set(clusterState);
            this.clusterApplier.onNewClusterState(reason, this::clusterState, (source, e) -> {});
        }
    }

    private boolean localNodeMaster() {
        return this.clusterState().nodes().isLocalNodeElectedMaster();
    }

    private void handleAnotherMaster(ClusterState localClusterState, final DiscoveryNode otherMaster, long otherClusterStateVersion, String reason) {
        assert (localClusterState.nodes().isLocalNodeElectedMaster()) : "handleAnotherMaster called but current node is not a master";
        assert (Thread.holdsLock(this.stateMutex));
        if (otherClusterStateVersion > localClusterState.version()) {
            this.rejoin("zen-disco-discovered another master with a new cluster_state [" + otherMaster + "][" + reason + "]");
        } else {
            logger.warn("discovered [{}] which is also master but with an older cluster_state, telling [{}] to rejoin the cluster ([{}])", (Object)otherMaster, (Object)otherMaster, (Object)reason);
            try {
                this.transportService.connectToNode(otherMaster);
                this.transportService.sendRequest(otherMaster, DISCOVERY_REJOIN_ACTION_NAME, new RejoinClusterRequest(localClusterState.nodes().getLocalNodeId()), new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleException(TransportException exp) {
                        logger.warn(() -> new ParameterizedMessage("failed to send rejoin request to [{}]", (Object)otherMaster), (Throwable)exp);
                    }
                });
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to send rejoin request to [{}]", (Object)otherMaster), (Throwable)e);
            }
        }
    }

    private ZenPing.PingCollection pingAndWait(TimeValue timeout) {
        CompletableFuture response = new CompletableFuture();
        try {
            this.zenPing.ping(response::complete, timeout);
        }
        catch (Exception ex) {
            response.completeExceptionally(ex);
        }
        try {
            return (ZenPing.PingCollection)response.get();
        }
        catch (InterruptedException e) {
            logger.trace("pingAndWait interrupted");
            return new ZenPing.PingCollection();
        }
        catch (ExecutionException e) {
            logger.warn("Ping execution failed", (Throwable)e);
            return new ZenPing.PingCollection();
        }
    }

    @Override
    public void onIncomingClusterState(ClusterState incomingState) {
        ZenDiscovery.validateIncomingState(logger, incomingState, this.committedState.get());
        this.pendingStatesQueue.addPending(incomingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClusterStateCommitted(String stateUUID, final ActionListener<Void> processedListener) {
        ClusterState state = this.pendingStatesQueue.markAsCommitted(stateUUID, new PendingClusterStatesQueue.StateProcessedListener(){

            @Override
            public void onNewClusterStateProcessed() {
                processedListener.onResponse(null);
            }

            @Override
            public void onNewClusterStateFailed(Exception e) {
                processedListener.onFailure(e);
            }
        });
        if (state != null) {
            Object object = this.stateMutex;
            synchronized (object) {
                this.processNextCommittedClusterState("master " + state.nodes().getMasterNode() + " committed version [" + state.version() + "]");
            }
        }
    }

    static void validateIncomingState(Logger logger, ClusterState incomingState, ClusterState lastState) {
        ClusterName incomingClusterName = incomingState.getClusterName();
        if (!incomingClusterName.equals(lastState.getClusterName())) {
            logger.warn("received cluster state from [{}] which is also master but with a different cluster name [{}]", (Object)incomingState.nodes().getMasterNode(), (Object)incomingClusterName);
            throw new IllegalStateException("received state from a node that is not part of the cluster");
        }
        if (!lastState.nodes().getLocalNode().equals(incomingState.nodes().getLocalNode())) {
            logger.warn("received a cluster state from [{}] and not part of the cluster, should not happen", (Object)incomingState.nodes().getMasterNode());
            throw new IllegalStateException("received state with a local node that does not match the current local node");
        }
        if (ZenDiscovery.shouldIgnoreOrRejectNewClusterState(logger, lastState, incomingState)) {
            String message = String.format(Locale.ROOT, "rejecting cluster state version [%d] uuid [%s] received from [%s]", incomingState.version(), incomingState.stateUUID(), incomingState.nodes().getMasterNodeId());
            logger.warn(message);
            throw new IllegalStateException(message);
        }
    }

    public final Collection<BiConsumer<DiscoveryNode, ClusterState>> getOnJoinValidators() {
        return this.onJoinValidators;
    }

    private class JoinThreadControl {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final AtomicReference<Thread> currentJoinThread = new AtomicReference();

        private JoinThreadControl() {
        }

        public boolean joinThreadActive() {
            Thread currentThread = this.currentJoinThread.get();
            return this.running.get() && currentThread != null && currentThread.isAlive();
        }

        public boolean joinThreadActive(Thread joinThread) {
            return this.running.get() && joinThread.equals(this.currentJoinThread.get());
        }

        public void stopRunningThreadAndRejoin(String reason) {
            assert (Thread.holdsLock(ZenDiscovery.this.stateMutex));
            this.currentJoinThread.set(null);
            ZenDiscovery.this.rejoin(reason);
        }

        public void startNewThreadIfNotRunning() {
            assert (Thread.holdsLock(ZenDiscovery.this.stateMutex));
            if (this.joinThreadActive()) {
                return;
            }
            ZenDiscovery.this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentThread = Thread.currentThread();
                    if (!JoinThreadControl.this.currentJoinThread.compareAndSet(null, currentThread)) {
                        return;
                    }
                    while (JoinThreadControl.this.running.get() && JoinThreadControl.this.joinThreadActive(currentThread)) {
                        try {
                            ZenDiscovery.this.innerJoinCluster();
                            return;
                        }
                        catch (Exception e) {
                            logger.error("unexpected error while joining cluster, trying again", (Throwable)e);
                            assert (ExceptionsHelper.reThrowIfNotNull(e));
                        }
                    }
                }
            });
        }

        public void markThreadAsDoneAndStartNew(Thread joinThread) {
            assert (Thread.holdsLock(ZenDiscovery.this.stateMutex));
            if (!this.markThreadAsDone(joinThread)) {
                return;
            }
            this.startNewThreadIfNotRunning();
        }

        public boolean markThreadAsDone(Thread joinThread) {
            assert (Thread.holdsLock(ZenDiscovery.this.stateMutex));
            return this.currentJoinThread.compareAndSet(joinThread, null);
        }

        public void stop() {
            this.running.set(false);
            Thread joinThread = this.currentJoinThread.getAndSet(null);
            if (joinThread != null) {
                joinThread.interrupt();
            }
        }

        public void start() {
            this.running.set(true);
        }
    }

    class RejoinClusterRequestHandler
    implements TransportRequestHandler<RejoinClusterRequest> {
        RejoinClusterRequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void messageReceived(RejoinClusterRequest request, TransportChannel channel) throws Exception {
            try {
                channel.sendResponse(TransportResponse.Empty.INSTANCE);
            }
            catch (Exception e) {
                logger.warn("failed to send response on rejoin cluster request handling", (Throwable)e);
            }
            Object object = ZenDiscovery.this.stateMutex;
            synchronized (object) {
                ZenDiscovery.this.rejoin("received a request to rejoin the cluster from [" + request.fromNodeId + "]");
            }
        }
    }

    public static class RejoinClusterRequest
    extends TransportRequest {
        private String fromNodeId;

        RejoinClusterRequest(String fromNodeId) {
            this.fromNodeId = fromNodeId;
        }

        public RejoinClusterRequest() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.fromNodeId = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.fromNodeId);
        }
    }

    private class MasterNodeFailureListener
    implements MasterFaultDetection.Listener {
        private MasterNodeFailureListener() {
        }

        @Override
        public void onMasterFailure(DiscoveryNode masterNode, Throwable cause, String reason) {
            ZenDiscovery.this.handleMasterGone(masterNode, cause, reason);
        }
    }

    private class NodeFaultDetectionListener
    extends NodesFaultDetection.Listener {
        private final AtomicInteger pingsWhileMaster = new AtomicInteger(0);

        private NodeFaultDetectionListener() {
        }

        @Override
        public void onNodeFailure(DiscoveryNode node, String reason) {
            ZenDiscovery.this.handleNodeFailure(node, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPingReceived(NodesFaultDetection.PingRequest pingRequest) {
            if (!ZenDiscovery.this.localNodeMaster()) {
                this.pingsWhileMaster.set(0);
                return;
            }
            if (this.pingsWhileMaster.incrementAndGet() < ZenDiscovery.this.maxPingsFromAnotherMaster) {
                logger.trace("got a ping from another master {}. current ping count: [{}]", (Object)pingRequest.masterNode(), (Object)this.pingsWhileMaster.get());
                return;
            }
            logger.debug("got a ping from another master {}. resolving who should rejoin. current ping count: [{}]", (Object)pingRequest.masterNode(), (Object)this.pingsWhileMaster.get());
            Object object = ZenDiscovery.this.stateMutex;
            synchronized (object) {
                ClusterState currentState = (ClusterState)ZenDiscovery.this.committedState.get();
                if (currentState.nodes().isLocalNodeElectedMaster()) {
                    this.pingsWhileMaster.set(0);
                    ZenDiscovery.this.handleAnotherMaster(currentState, pingRequest.masterNode(), pingRequest.clusterStateVersion(), "node fd ping");
                }
            }
        }
    }

    private class MembershipListener
    implements MembershipAction.MembershipListener {
        private MembershipListener() {
        }

        @Override
        public void onJoin(DiscoveryNode node, MembershipAction.JoinCallback callback) {
            ZenDiscovery.this.handleJoinRequest(node, ZenDiscovery.this.clusterState(), callback);
        }

        @Override
        public void onLeave(DiscoveryNode node) {
            ZenDiscovery.this.handleLeaveRequest(node);
        }
    }

    public static class NodeRemovalClusterStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final AllocationService allocationService;
        private final ElectMasterService electMasterService;
        private final Consumer<String> rejoin;
        private final Logger logger;

        public NodeRemovalClusterStateTaskExecutor(AllocationService allocationService, ElectMasterService electMasterService, Consumer<String> rejoin, Logger logger) {
            this.allocationService = allocationService;
            this.electMasterService = electMasterService;
            this.rejoin = rejoin;
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            DiscoveryNodes.Builder remainingNodesBuilder = DiscoveryNodes.builder(currentState.nodes());
            boolean removed = false;
            for (Task task : tasks) {
                if (currentState.nodes().nodeExists(task.node())) {
                    remainingNodesBuilder.remove(task.node());
                    removed = true;
                    continue;
                }
                this.logger.debug("node [{}] does not exist in cluster state, ignoring", (Object)task);
            }
            if (!removed) {
                return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(currentState);
            }
            ClusterState remainingNodesClusterState = this.remainingNodesClusterState(currentState, remainingNodesBuilder);
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            if (!this.electMasterService.hasEnoughMasterNodes(remainingNodesClusterState.nodes())) {
                int masterNodes = this.electMasterService.countMasterNodes(remainingNodesClusterState.nodes());
                this.rejoin.accept(LoggerMessageFormat.format("not enough master nodes (has [{}], but needed [{}])", masterNodes, this.electMasterService.minimumMasterNodes()));
                return resultBuilder.build(currentState);
            }
            ClusterState ptasksDisassociatedState = PersistentTasksCustomMetaData.disassociateDeadNodes(remainingNodesClusterState);
            return resultBuilder.build(this.allocationService.disassociateDeadNodes(ptasksDisassociatedState, true, this.describeTasks(tasks)));
        }

        ClusterState remainingNodesClusterState(ClusterState currentState, DiscoveryNodes.Builder remainingNodesBuilder) {
            return ClusterState.builder(currentState).nodes(remainingNodesBuilder).build();
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing node removal [{}]", (Object)source);
        }

        public static class Task {
            private final DiscoveryNode node;
            private final String reason;

            public Task(DiscoveryNode node, String reason) {
                this.node = node;
                this.reason = reason;
            }

            public DiscoveryNode node() {
                return this.node;
            }

            public String reason() {
                return this.reason;
            }

            public String toString() {
                return this.node + " " + this.reason;
            }
        }
    }
}

