/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.binding.springmvc.async;

import io.tracee.Tracee;
import java.util.Map;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.scheduling.annotation.AnnotationAsyncExecutionInterceptor;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;
import org.springframework.scheduling.annotation.AsyncAnnotationBeanPostProcessor;

public class PreTpicAsyncBeanPostProcessor
extends AsyncAnnotationBeanPostProcessor {
    public PreTpicAsyncBeanPostProcessor(Executor executor) {
        this.advisor = new TpicPreAdvisor(executor);
        this.setBeforeExistingAdvisors(true);
    }

    boolean isBeforeExistingAdvisors() {
        return this.beforeExistingAdvisors;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
    }

    static class DelegateTpicToAsyncInterceptor
    extends AnnotationAsyncExecutionInterceptor {
        DelegateTpicToAsyncInterceptor(Executor defaultExecutor) {
            super(defaultExecutor);
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation instanceof ReflectiveMethodInvocation) {
                Map tpic = Tracee.getBackend().copyToMap();
                ((ReflectiveMethodInvocation)invocation).setUserAttribute("TPIC", (Object)tpic);
            }
            return invocation.proceed();
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }
    }

    static class TpicPreAdvisor
    extends AsyncAnnotationAdvisor {
        private final Executor executor;

        TpicPreAdvisor(Executor executor) {
            this.executor = executor;
            this.setTaskExecutor(executor);
        }

        public Advice getAdvice() {
            return new DelegateTpicToAsyncInterceptor(this.executor);
        }
    }
}

