/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure.template;

import io.temporal.spring.boot.TemporalOptionsCustomizer;
import io.temporal.spring.boot.WorkerOptionsCustomizer;
import io.temporal.spring.boot.autoconfigure.properties.WorkerProperties;
import io.temporal.worker.WorkerOptions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class WorkerOptionsTemplate {
    @Nonnull
    private final String taskQueue;
    @Nonnull
    private final String workerName;
    @Nullable
    private final WorkerProperties workerProperties;
    @Nullable
    private final TemporalOptionsCustomizer<WorkerOptions.Builder> customizer;

    WorkerOptionsTemplate(@Nonnull String workerName, @Nonnull String taskQueue, @Nullable WorkerProperties workerProperties, @Nullable TemporalOptionsCustomizer<WorkerOptions.Builder> customizer) {
        this.workerName = workerName;
        this.taskQueue = taskQueue;
        this.workerProperties = workerProperties;
        this.customizer = customizer;
    }

    WorkerOptions createWorkerOptions() {
        WorkerOptions.Builder options = WorkerOptions.newBuilder();
        if (this.workerProperties != null) {
            WorkerProperties.VirtualThreadConfigurationProperties virtualThreadConfiguration;
            WorkerProperties.BuildIdConfigurationProperties buildIdConfigurations;
            WorkerProperties.RateLimitsConfigurationProperties rateLimitConfiguration;
            WorkerProperties.CapacityConfigurationProperties threadsConfiguration = this.workerProperties.getCapacity();
            if (threadsConfiguration != null) {
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentWorkflowTaskExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentWorkflowTaskExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentActivityExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentActivityExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentLocalActivityExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentLocalActivityExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentNexusTasksExecutors()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentNexusExecutionSize(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentWorkflowTaskPollers()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentWorkflowTaskPollers(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentActivityTaskPollers()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentActivityTaskPollers(arg_0));
                Optional.ofNullable(threadsConfiguration.getMaxConcurrentNexusTaskPollers()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxConcurrentNexusTaskPollers(arg_0));
            }
            if ((rateLimitConfiguration = this.workerProperties.getRateLimits()) != null) {
                Optional.ofNullable(rateLimitConfiguration.getMaxWorkerActivitiesPerSecond()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxWorkerActivitiesPerSecond(arg_0));
                Optional.ofNullable(rateLimitConfiguration.getMaxTaskQueueActivitiesPerSecond()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setMaxTaskQueueActivitiesPerSecond(arg_0));
            }
            if ((buildIdConfigurations = this.workerProperties.getBuildId()) != null) {
                Optional.ofNullable(buildIdConfigurations.getWorkerBuildId()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setBuildId(arg_0));
                options.setUseBuildIdForVersioning(buildIdConfigurations.getEnabledWorkerVersioning());
            }
            if ((virtualThreadConfiguration = this.workerProperties.getVirtualThreads()) != null) {
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreads()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreads(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnWorkflowWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnWorkflowWorker(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnActivityWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnActivityWorker(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnLocalActivityWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnLocalActivityWorker(arg_0));
                Optional.ofNullable(virtualThreadConfiguration.isUsingVirtualThreadsOnNexusWorker()).ifPresent(arg_0 -> ((WorkerOptions.Builder)options).setUsingVirtualThreadsOnNexusWorker(arg_0));
            }
        }
        if (this.customizer != null) {
            options = this.customizer.customize(options);
            if (this.customizer instanceof WorkerOptionsCustomizer) {
                options = ((WorkerOptionsCustomizer)this.customizer).customize(options, this.workerName, this.taskQueue);
            }
        }
        return options.build();
    }
}

