/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.spring.boot.autoconfigure;

import com.uber.m3.tally.RootScopeBuilder;
import com.uber.m3.tally.Scope;
import com.uber.m3.tally.StatsReporter;
import com.uber.m3.util.Duration;
import io.micrometer.core.instrument.MeterRegistry;
import io.temporal.common.reporter.MicrometerClientStatsReporter;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(name={"org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration"})
@ConditionalOnBean(value={MeterRegistry.class})
public class MetricsScopeAutoConfiguration {
    @Bean(name={"temporalMetricsScope"}, destroyMethod="close")
    public Scope scope(@Autowired(required=false) @Nullable MeterRegistry meterRegistry) {
        MicrometerClientStatsReporter reporter = new MicrometerClientStatsReporter(meterRegistry);
        return new RootScopeBuilder().reporter((StatsReporter)reporter).reportEvery(Duration.ofSeconds((double)10.0));
    }
}

