/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal;

import io.grpc.Status;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BackoffThrottler {
    private final Duration regularInitialSleep;
    private final Duration congestionInitialSleep;
    private final Duration maxSleep;
    private final double backoffCoefficient;
    private final double maxJitterCoefficient;
    private int failureCount = 0;
    private Status.Code lastFailureCode = Status.Code.OK;

    public BackoffThrottler(Duration regularInitialSleep, Duration congestionInitialSleep, @Nullable Duration maxSleep, double backoffCoefficient, double maxJitterCoefficient) {
        Objects.requireNonNull(regularInitialSleep, "regularInitialSleep");
        Objects.requireNonNull(congestionInitialSleep, "congestionInitialSleep");
        if (backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("backoff coefficient less than 1.0: " + backoffCoefficient);
        }
        if (maxJitterCoefficient < 0.0 || maxJitterCoefficient >= 1.0) {
            throw new IllegalArgumentException("maxJitterCoefficient has to be >= 0 and < 1.0: " + maxJitterCoefficient);
        }
        this.regularInitialSleep = regularInitialSleep;
        this.congestionInitialSleep = congestionInitialSleep;
        this.maxSleep = maxSleep;
        this.backoffCoefficient = backoffCoefficient;
        this.maxJitterCoefficient = maxJitterCoefficient;
    }

    public long getSleepTime() {
        if (this.failureCount == 0) {
            return 0L;
        }
        Duration initial = this.lastFailureCode == Status.Code.RESOURCE_EXHAUSTED ? this.congestionInitialSleep : this.regularInitialSleep;
        double jitter = Math.random() * this.maxJitterCoefficient * 2.0 - this.maxJitterCoefficient;
        double sleepMillis = Math.pow(this.backoffCoefficient, this.failureCount - 1) * (double)initial.toMillis() * (1.0 + jitter);
        if (this.maxSleep != null) {
            return Math.min((long)sleepMillis, this.maxSleep.toMillis());
        }
        return (long)sleepMillis;
    }

    public int getAttemptCount() {
        return this.failureCount;
    }

    public void success() {
        this.failureCount = 0;
        this.lastFailureCode = Status.Code.OK;
    }

    public void failure(Status.Code failureCode) {
        ++this.failureCount;
        this.lastFailureCode = failureCode;
    }
}

