/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.common.Experimental;
import java.util.Objects;

public class SideEffectOptions {
    private static final SideEffectOptions DEFAULT_INSTANCE = SideEffectOptions.newBuilder().build();
    private final String summary;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(SideEffectOptions options) {
        return new Builder(options);
    }

    public static SideEffectOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private SideEffectOptions(String summary) {
        this.summary = summary;
    }

    public String getSummary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "SideEffectOptions{summary='" + this.summary + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SideEffectOptions that = (SideEffectOptions)o;
        return Objects.equals(this.summary, that.summary);
    }

    public int hashCode() {
        return Objects.hash(this.summary);
    }

    public static final class Builder {
        private String summary;

        private Builder() {
        }

        private Builder(SideEffectOptions options) {
            if (options == null) {
                return;
            }
            this.summary = options.summary;
        }

        @Experimental
        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public SideEffectOptions build() {
            return new SideEffectOptions(this.summary);
        }
    }
}

