/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.worker.tuning;

import io.temporal.worker.tuning.ActivitySlotInfo;
import io.temporal.worker.tuning.LocalActivitySlotInfo;
import io.temporal.worker.tuning.NexusSlotInfo;
import io.temporal.worker.tuning.ResourceBasedController;
import io.temporal.worker.tuning.ResourceBasedControllerOptions;
import io.temporal.worker.tuning.ResourceBasedSlotOptions;
import io.temporal.worker.tuning.ResourceBasedSlotSupplier;
import io.temporal.worker.tuning.SlotSupplier;
import io.temporal.worker.tuning.WorkerTuner;
import io.temporal.worker.tuning.WorkflowSlotInfo;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nonnull;

public class ResourceBasedTuner
implements WorkerTuner {
    public static final ResourceBasedSlotOptions DEFAULT_WORKFLOW_SLOT_OPTIONS = ResourceBasedSlotOptions.newBuilder().setMinimumSlots(5).setMaximumSlots(500).setRampThrottle(Duration.ZERO).build();
    public static final ResourceBasedSlotOptions DEFAULT_ACTIVITY_SLOT_OPTIONS = ResourceBasedSlotOptions.newBuilder().setMinimumSlots(1).setMaximumSlots(1000).setRampThrottle(Duration.ofMillis(50L)).build();
    public static final ResourceBasedSlotOptions DEFAULT_NEXUS_SLOT_OPTIONS = ResourceBasedSlotOptions.newBuilder().setMinimumSlots(1).setMaximumSlots(1000).setRampThrottle(Duration.ofMillis(50L)).build();
    private final ResourceBasedController controller;
    private final ResourceBasedSlotOptions workflowSlotOptions;
    private final ResourceBasedSlotOptions activitySlotOptions;
    private final ResourceBasedSlotOptions localActivitySlotOptions;
    private final ResourceBasedSlotOptions nexusSlotOptions;
    private final ScheduledExecutorService executor;

    public static Builder newBuilder() {
        return new Builder();
    }

    public ResourceBasedTuner(ResourceBasedControllerOptions controllerOptions, ResourceBasedSlotOptions workflowSlotOptions, ResourceBasedSlotOptions activitySlotOptions, ResourceBasedSlotOptions localActivitySlotOptions, ResourceBasedSlotOptions nexusSlotOptions, ScheduledExecutorService executor) {
        this.controller = ResourceBasedController.newSystemInfoController(controllerOptions);
        this.workflowSlotOptions = workflowSlotOptions;
        this.activitySlotOptions = activitySlotOptions;
        this.localActivitySlotOptions = localActivitySlotOptions;
        this.nexusSlotOptions = nexusSlotOptions;
        this.executor = executor;
    }

    @Override
    @Nonnull
    public SlotSupplier<WorkflowSlotInfo> getWorkflowTaskSlotSupplier() {
        return ResourceBasedSlotSupplier.createForWorkflow(this.controller, this.workflowSlotOptions, this.executor);
    }

    @Override
    @Nonnull
    public SlotSupplier<ActivitySlotInfo> getActivityTaskSlotSupplier() {
        return ResourceBasedSlotSupplier.createForActivity(this.controller, this.activitySlotOptions, this.executor);
    }

    @Override
    @Nonnull
    public SlotSupplier<LocalActivitySlotInfo> getLocalActivitySlotSupplier() {
        return ResourceBasedSlotSupplier.createForLocalActivity(this.controller, this.localActivitySlotOptions, this.executor);
    }

    @Override
    @Nonnull
    public SlotSupplier<NexusSlotInfo> getNexusSlotSupplier() {
        return ResourceBasedSlotSupplier.createForNexus(this.controller, this.nexusSlotOptions, this.executor);
    }

    public static final class Builder {
        private ResourceBasedControllerOptions controllerOptions;
        @Nonnull
        private ResourceBasedSlotOptions workflowSlotOptions = DEFAULT_WORKFLOW_SLOT_OPTIONS;
        @Nonnull
        private ResourceBasedSlotOptions activitySlotOptions = DEFAULT_ACTIVITY_SLOT_OPTIONS;
        @Nonnull
        private ResourceBasedSlotOptions localActivitySlotOptions = DEFAULT_ACTIVITY_SLOT_OPTIONS;
        @Nonnull
        private ResourceBasedSlotOptions nexusSlotOptions = DEFAULT_NEXUS_SLOT_OPTIONS;
        @Nonnull
        private ScheduledExecutorService executor;

        private Builder() {
        }

        public Builder setControllerOptions(ResourceBasedControllerOptions controllerOptions) {
            this.controllerOptions = controllerOptions;
            return this;
        }

        public Builder setWorkflowSlotOptions(@Nonnull ResourceBasedSlotOptions workflowSlotOptions) {
            this.workflowSlotOptions = workflowSlotOptions;
            return this;
        }

        public Builder setActivitySlotOptions(@Nonnull ResourceBasedSlotOptions activitySlotOptions) {
            this.activitySlotOptions = activitySlotOptions;
            return this;
        }

        public Builder setLocalActivitySlotOptions(@Nonnull ResourceBasedSlotOptions localActivitySlotOptions) {
            this.localActivitySlotOptions = localActivitySlotOptions;
            return this;
        }

        public Builder setNexusSlotOptions(@Nonnull ResourceBasedSlotOptions nexusSlotOptions) {
            this.nexusSlotOptions = nexusSlotOptions;
            return this;
        }

        public Builder setExecutor(@Nonnull ScheduledExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ResourceBasedTuner build() {
            return new ResourceBasedTuner(this.controllerOptions, this.workflowSlotOptions, this.activitySlotOptions, this.localActivitySlotOptions, this.nexusSlotOptions, this.executor);
        }
    }
}

