/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.workflow;

import io.temporal.common.RetryOptions;
import io.temporal.common.SearchAttributes;
import io.temporal.common.VersioningIntent;
import io.temporal.common.context.ContextPropagator;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ContinueAsNewOptions {
    private static final ContinueAsNewOptions DEFAULT_INSTANCE = ContinueAsNewOptions.newBuilder().build();
    @Nullable
    private final Duration workflowRunTimeout;
    @Nullable
    private final String taskQueue;
    @Nullable
    private final RetryOptions retryOptions;
    @Nullable
    private final Duration workflowTaskTimeout;
    @Nullable
    private final Map<String, Object> memo;
    @Nullable
    private final Map<String, Object> searchAttributes;
    @Nullable
    private final SearchAttributes typedSearchAttributes;
    @Nullable
    private final List<ContextPropagator> contextPropagators;
    @Nullable
    private final VersioningIntent versioningIntent;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ContinueAsNewOptions options) {
        return new Builder(options);
    }

    public static ContinueAsNewOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ContinueAsNewOptions(@Nullable Duration workflowRunTimeout, @Nullable String taskQueue, @Nullable RetryOptions retryOptions, @Nullable Duration workflowTaskTimeout, @Nullable Map<String, Object> memo, @Nullable Map<String, Object> searchAttributes, @Nullable SearchAttributes typedSearchAttributes, @Nullable List<ContextPropagator> contextPropagators, @Nullable VersioningIntent versioningIntent) {
        this.workflowRunTimeout = workflowRunTimeout;
        this.taskQueue = taskQueue;
        this.retryOptions = retryOptions;
        this.workflowTaskTimeout = workflowTaskTimeout;
        this.memo = memo;
        this.searchAttributes = searchAttributes;
        this.typedSearchAttributes = typedSearchAttributes;
        this.contextPropagators = contextPropagators;
        this.versioningIntent = versioningIntent;
    }

    @Nullable
    public Duration getWorkflowRunTimeout() {
        return this.workflowRunTimeout;
    }

    @Nullable
    public String getTaskQueue() {
        return this.taskQueue;
    }

    @Nullable
    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    @Nullable
    public Duration getWorkflowTaskTimeout() {
        return this.workflowTaskTimeout;
    }

    @Nullable
    public Map<String, Object> getMemo() {
        return this.memo;
    }

    @Deprecated
    @Nullable
    public Map<String, Object> getSearchAttributes() {
        return this.searchAttributes;
    }

    @Nullable
    public SearchAttributes getTypedSearchAttributes() {
        return this.typedSearchAttributes;
    }

    @Nullable
    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    @Deprecated
    @Nullable
    public VersioningIntent getVersioningIntent() {
        return this.versioningIntent;
    }

    public static final class Builder {
        private Duration workflowRunTimeout;
        private String taskQueue;
        private RetryOptions retryOptions;
        private Duration workflowTaskTimeout;
        private Map<String, Object> memo;
        private Map<String, Object> searchAttributes;
        private SearchAttributes typedSearchAttributes;
        private List<ContextPropagator> contextPropagators;
        private VersioningIntent versioningIntent;

        private Builder() {
        }

        private Builder(ContinueAsNewOptions options) {
            if (options == null) {
                return;
            }
            this.workflowRunTimeout = options.workflowRunTimeout;
            this.taskQueue = options.taskQueue;
            this.retryOptions = options.retryOptions;
            this.workflowTaskTimeout = options.workflowTaskTimeout;
            this.memo = options.getMemo();
            this.searchAttributes = options.getSearchAttributes();
            this.typedSearchAttributes = options.getTypedSearchAttributes();
            this.contextPropagators = options.getContextPropagators();
            this.versioningIntent = options.versioningIntent;
        }

        public Builder setWorkflowRunTimeout(Duration workflowRunTimeout) {
            this.workflowRunTimeout = workflowRunTimeout;
            return this;
        }

        public Builder setTaskQueue(String taskQueue) {
            this.taskQueue = taskQueue;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setWorkflowTaskTimeout(Duration workflowTaskTimeout) {
            this.workflowTaskTimeout = workflowTaskTimeout;
            return this;
        }

        public Builder setMemo(Map<String, Object> memo) {
            this.memo = memo;
            return this;
        }

        @Deprecated
        public Builder setSearchAttributes(Map<String, Object> searchAttributes) {
            if (searchAttributes != null && !searchAttributes.isEmpty() && this.typedSearchAttributes != null) {
                throw new IllegalArgumentException("Cannot have search attributes and typed search attributes");
            }
            this.searchAttributes = searchAttributes;
            return this;
        }

        public Builder setTypedSearchAttributes(SearchAttributes typedSearchAttributes) {
            if (typedSearchAttributes != null && this.searchAttributes != null && !this.searchAttributes.isEmpty()) {
                throw new IllegalArgumentException("Cannot have typed search attributes and search attributes");
            }
            this.typedSearchAttributes = typedSearchAttributes;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        @Deprecated
        public Builder setVersioningIntent(VersioningIntent versioningIntent) {
            this.versioningIntent = versioningIntent;
            return this;
        }

        public ContinueAsNewOptions build() {
            return new ContinueAsNewOptions(this.workflowRunTimeout, this.taskQueue, this.retryOptions, this.workflowTaskTimeout, this.memo, this.searchAttributes, this.typedSearchAttributes, this.contextPropagators, this.versioningIntent);
        }
    }
}

