/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.sdk.v1.UserMetadata;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.workflow.Functions;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExecuteLocalActivityParameters {
    @Nonnull
    private final PollActivityTaskQueueResponse.Builder activityTaskBuilder;
    private final long originalScheduledTimestamp;
    @Nullable
    private final Failure previousLocalExecutionFailure;
    @Nonnull
    private final Duration localRetryThreshold;
    private final boolean doNotIncludeArgumentsIntoMarker;
    @Nullable
    private final Duration scheduleToStartTimeout;
    @Nullable
    private Functions.Proc onNewAttemptCallback;
    private final UserMetadata metadata;

    public ExecuteLocalActivityParameters(@Nonnull PollActivityTaskQueueResponse.Builder activityTaskBuilder, @Nullable Duration scheduleToStartTimeout, long originalScheduledTimestamp, @Nullable Failure previousLocalExecutionFailure, boolean doNotIncludeArgumentsIntoMarker, @Nonnull Duration localRetryThreshold, UserMetadata metadata) {
        this.activityTaskBuilder = Objects.requireNonNull(activityTaskBuilder, "activityTaskBuilder");
        this.scheduleToStartTimeout = scheduleToStartTimeout;
        this.originalScheduledTimestamp = originalScheduledTimestamp;
        this.previousLocalExecutionFailure = previousLocalExecutionFailure;
        this.doNotIncludeArgumentsIntoMarker = doNotIncludeArgumentsIntoMarker;
        this.localRetryThreshold = localRetryThreshold;
        this.onNewAttemptCallback = null;
        this.metadata = metadata;
    }

    public String getActivityId() {
        return this.activityTaskBuilder.getActivityId();
    }

    public ActivityType getActivityType() {
        return this.activityTaskBuilder.getActivityType();
    }

    public Payloads getInput() {
        return this.activityTaskBuilder.getInput();
    }

    public int getInitialAttempt() {
        return this.activityTaskBuilder.getAttempt();
    }

    @Nonnull
    public PollActivityTaskQueueResponse.Builder cloneActivityTaskBuilder() {
        return this.activityTaskBuilder.clone();
    }

    @Nullable
    public Duration getScheduleToCloseTimeout() {
        if (this.activityTaskBuilder.hasScheduleToCloseTimeout()) {
            return ProtobufTimeUtils.toJavaDuration(this.activityTaskBuilder.getScheduleToCloseTimeout());
        }
        return null;
    }

    public long getOriginalScheduledTimestamp() {
        return this.originalScheduledTimestamp;
    }

    @Nullable
    public Failure getPreviousLocalExecutionFailure() {
        return this.previousLocalExecutionFailure;
    }

    public boolean isDoNotIncludeArgumentsIntoMarker() {
        return this.doNotIncludeArgumentsIntoMarker;
    }

    @Nonnull
    public Duration getLocalRetryThreshold() {
        return this.localRetryThreshold;
    }

    @Nullable
    public Duration getScheduleToStartTimeout() {
        return this.scheduleToStartTimeout;
    }

    @Nonnull
    public Functions.Proc getOnNewAttemptCallback() {
        if (this.onNewAttemptCallback == null) {
            return () -> {};
        }
        return this.onNewAttemptCallback;
    }

    public void setOnNewAttemptCallback(@Nonnull Functions.Proc onNewAttemptCallback) {
        this.onNewAttemptCallback = onNewAttemptCallback;
    }

    public UserMetadata getMetadata() {
        return this.metadata;
    }
}

