/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.SpanCreationContext;
import io.temporal.opentracing.SpanOperationType;
import java.util.HashMap;
import javax.annotation.Nullable;

public class SpanFactory {
    private final OpenTracingOptions options;

    public SpanFactory(OpenTracingOptions options) {
        this.options = options;
    }

    public Tracer.SpanBuilder createWorkflowStartSpan(Tracer tracer, SpanOperationType operationType, String workflowType, String workflowId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(operationType).setActionName(workflowType).setWorkflowId(workflowId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createStartNexusOperationSpan(Tracer tracer, String serviceName, String operationName, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_NEXUS_OPERATION).setActionName(serviceName + "/" + operationName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "child_of");
    }

    public Tracer.SpanBuilder createChildWorkflowStartSpan(Tracer tracer, String childWorkflowType, String childWorkflowId, long startTimeMs, String parentWorkflowId, String parentRunId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_CHILD_WORKFLOW).setActionName(childWorkflowType).setWorkflowId(childWorkflowId).setParentWorkflowId(parentWorkflowId).setParentRunId(parentRunId).build();
        return this.createSpan(context, tracer, null, "child_of");
    }

    public Tracer.SpanBuilder createExternalWorkflowSignalSpan(Tracer tracer, String signalName, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.SIGNAL_EXTERNAL_WORKFLOW).setActionName(signalName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowSignalSpan(Tracer tracer, String signalName, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.SIGNAL_WORKFLOW).setActionName(signalName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowHandleSignalSpan(Tracer tracer, String signalName, String workflowId, String runId, SpanContext workflowSignalSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.HANDLE_SIGNAL).setActionName(signalName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, workflowSignalSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createContinueAsNewWorkflowStartSpan(Tracer tracer, String continueAsNewWorkflowType, String workflowId, String parentRunId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_CONTINUE_AS_NEW_WORKFLOW).setActionName(continueAsNewWorkflowType).setWorkflowId(workflowId).setParentRunId(parentRunId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowRunSpan(Tracer tracer, String workflowType, String workflowId, String runId, SpanContext workflowStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_WORKFLOW).setActionName(workflowType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, workflowStartSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createActivityStartSpan(Tracer tracer, String activityType, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_ACTIVITY).setActionName(activityType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "child_of");
    }

    public Tracer.SpanBuilder createActivityRunSpan(Tracer tracer, String activityType, String workflowId, String runId, SpanContext activityStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_ACTIVITY).setActionName(activityType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, activityStartSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createStartNexusOperationSpan(Tracer tracer, String serviceName, String operationName, SpanContext nexusStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_START_NEXUS_OPERATION).setActionName(serviceName + "/" + operationName).build();
        return this.createSpan(context, tracer, nexusStartSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createCancelNexusOperationSpan(Tracer tracer, String serviceName, String operationName, SpanContext nexusStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_CANCEL_NEXUS_OPERATION).setActionName(serviceName + "/" + operationName).build();
        return this.createSpan(context, tracer, nexusStartSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowStartUpdateSpan(Tracer tracer, String updateName, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.UPDATE_WORKFLOW).setActionName(updateName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowExecuteUpdateSpan(Tracer tracer, String updateName, String workflowId, String runId, SpanContext workflowUpdateSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.HANDLE_UPDATE).setActionName(updateName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, workflowUpdateSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowQuerySpan(Tracer tracer, String updateName, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.QUERY_WORKFLOW).setActionName(updateName).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowHandleQuerySpan(Tracer tracer, String queryName, SpanContext workflowQuerySpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.HANDLE_QUERY).setActionName(queryName).build();
        return this.createSpan(context, tracer, workflowQuerySpanContext, "follows_from");
    }

    public void logFail(Span toSpan, Throwable failReason) {
        toSpan.setTag("failed", true);
        toSpan.setTag((Tag)Tags.ERROR, (Object)this.options.getIsErrorPredicate().test(failReason));
        HashMap<String, Object> logPayload = new HashMap<String, Object>();
        logPayload.put("event", "error");
        logPayload.put("error.kind", failReason.getClass().getName());
        logPayload.put("error.object", failReason);
        logPayload.put("stack", Throwables.getStackTraceAsString((Throwable)failReason));
        String message = failReason.getMessage();
        if (message != null) {
            logPayload.put("message", message);
        }
        toSpan.log(System.currentTimeMillis(), logPayload);
    }

    public void logEviction(Span toSpan) {
        toSpan.setTag("evicted", true);
    }

    private Tracer.SpanBuilder createSpan(SpanCreationContext context, Tracer tracer, @Nullable SpanContext parentSpanContext, @Nullable String parentReferenceType) {
        Span activeSpan = tracer.activeSpan();
        SpanContext parent = activeSpan != null ? activeSpan.context() : parentSpanContext;
        Tracer.SpanBuilder builder = this.options.getSpanBuilderProvider().createSpanBuilder(tracer, context);
        if (parent != null) {
            builder.addReference((String)MoreObjects.firstNonNull((Object)parentReferenceType, (Object)"follows_from"), parent);
        }
        return builder;
    }
}

