/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.proviso.archive.source;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import io.tesla.proviso.archive.ExtendedArchiveEntry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.FileEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.codehaus.plexus.util.DirectoryScanner;

public class DirectorySource
implements Source {
    private final File[] sourceDirectories;

    public DirectorySource(File ... sourceDirectories) {
        this.sourceDirectories = sourceDirectories;
    }

    @Override
    public Iterable<ExtendedArchiveEntry> entries() {
        return () -> {
            Iterator[] iterators = new DirectoryEntryIterator[this.sourceDirectories.length];
            int i = 0;
            while (i < iterators.length) {
                iterators[i] = new DirectoryEntryIterator(this.sourceDirectories[i]);
                ++i;
            }
            return Iterators.concat((Iterator[])iterators);
        };
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    class DirectoryEntryIterator
    implements Iterator<ExtendedArchiveEntry> {
        final String[] files;
        final File sourceDirectory;
        int currentFileIndex;

        DirectoryEntryIterator(File sourceDirectory) {
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(sourceDirectory);
            scanner.setCaseSensitive(true);
            scanner.scan();
            ArrayList entries = Lists.newArrayList();
            String[] stringArray = (String[])ObjectArrays.concat((Object[])scanner.getIncludedFiles(), (Object[])scanner.getIncludedDirectories(), String.class);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String includedFile = stringArray[n2];
                if (!includedFile.isEmpty()) {
                    entries.add(includedFile.replace('\\', '/'));
                }
                ++n2;
            }
            this.files = entries.toArray(new String[entries.size()]);
            this.sourceDirectory = sourceDirectory;
        }

        @Override
        public boolean hasNext() {
            return this.currentFileIndex != this.files.length;
        }

        @Override
        public ExtendedArchiveEntry next() {
            String pathRelativeToSourceDirectory = this.files[this.currentFileIndex++];
            File file = new File(this.sourceDirectory, pathRelativeToSourceDirectory);
            String archiveEntryName = String.format("%s/%s", this.sourceDirectory.getName().replace('\\', '/'), pathRelativeToSourceDirectory);
            return new FileEntry(archiveEntryName, file);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove method not implemented");
        }
    }
}

