/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.v2.client.ClientAttributes;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.client.manager.ClientManager;
import com.alibaba.nacos.naming.misc.Loggers;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ClientAttributesFilter
implements Filter {
    private static final String BEAT_URI = "/beat";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String ZERO = "0";
    @Autowired
    private ClientManager clientManager;
    public static ThreadLocal<ClientAttributes> threadLocalClientAttributes = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        try {
            try {
                if ("/nacos/v1/ns/instance".equals(request.getRequestURI()) && request.getMethod().equals("POST")) {
                    ClientAttributes requestClientAttributes = ClientAttributesFilter.getClientAttributes(request);
                    threadLocalClientAttributes.set(requestClientAttributes);
                } else if ("/nacos/v1/ns/instance/beat".equals(request.getRequestURI())) {
                    ClientAttributes requestClientAttributes;
                    String ip = WebUtils.optional((HttpServletRequest)request, (String)IP, (String)"");
                    int port = Integer.parseInt(WebUtils.optional((HttpServletRequest)request, (String)PORT, (String)ZERO));
                    String clientId = IpPortBasedClient.getClientId(ip + ":" + port, true);
                    IpPortBasedClient client = (IpPortBasedClient)this.clientManager.getClient(clientId);
                    if (client != null && ClientAttributesFilter.canUpdateClientAttributes(client, requestClientAttributes = ClientAttributesFilter.getClientAttributes(request))) {
                        client.setAttributes(requestClientAttributes);
                    }
                }
            }
            catch (Exception e) {
                Loggers.SRV_LOG.error("handler client attributes error", (Throwable)e);
            }
            try {
                filterChain.doFilter((ServletRequest)request, servletResponse);
            }
            catch (ServletException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (threadLocalClientAttributes.get() != null) {
                threadLocalClientAttributes.remove();
            }
        }
    }

    private static boolean canUpdateClientAttributes(IpPortBasedClient client, ClientAttributes requestClientAttributes) {
        if (requestClientAttributes.getClientAttribute("Client-Version") == null) {
            return false;
        }
        return client.getClientAttributes() == null || client.getClientAttributes().getClientAttribute("Client-Version") == null;
    }

    public static ClientAttributes getClientAttributes(HttpServletRequest request) {
        String version = request.getHeader("Client-Version");
        String app = request.getHeader("app");
        String clientIp = request.getRemoteAddr();
        ClientAttributes clientAttributes = new ClientAttributes();
        if (version != null) {
            clientAttributes.addClientAttribute("Client-Version", version);
        }
        if (app != null) {
            clientAttributes.addClientAttribute("app", app);
        }
        if (clientIp != null) {
            clientAttributes.addClientAttribute("clientIp", clientIp);
        }
        return clientAttributes;
    }
}

