/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.executor;

import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.UdpPushService;
import com.alibaba.nacos.naming.push.v2.PushDataWrapper;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutor;
import com.alibaba.nacos.naming.push.v2.task.NamingPushCallback;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import org.springframework.stereotype.Component;

@Component
public class PushExecutorUdpImpl
implements PushExecutor {
    private final UdpPushService pushService;

    public PushExecutorUdpImpl(UdpPushService pushService) {
        this.pushService = pushService;
    }

    @Override
    public void doPush(String clientId, Subscriber subscriber, PushDataWrapper data) {
        this.pushService.pushDataWithoutCallback(subscriber, this.handleClusterData(this.replaceServiceInfoName(data, subscriber), subscriber));
    }

    @Override
    public void doPushWithCallback(String clientId, Subscriber subscriber, PushDataWrapper data, NamingPushCallback callBack) {
        ServiceInfo actualServiceInfo = this.replaceServiceInfoName(data, subscriber);
        callBack.setActualServiceInfo(actualServiceInfo);
        this.pushService.pushDataWithCallback(subscriber, this.handleClusterData(actualServiceInfo, subscriber), callBack);
    }

    private ServiceInfo replaceServiceInfoName(PushDataWrapper originalData, Subscriber subscriber) {
        ServiceInfo serviceInfo = ServiceUtil.selectInstancesWithHealthyProtection(originalData.getOriginalData(), originalData.getServiceMetadata(), false, true, subscriber);
        ServiceInfo result = new ServiceInfo();
        result.setName(NamingUtils.getGroupedName((String)serviceInfo.getName(), (String)serviceInfo.getGroupName()));
        result.setClusters(serviceInfo.getClusters());
        result.setHosts(serviceInfo.getHosts());
        result.setLastRefTime(serviceInfo.getLastRefTime());
        result.setCacheMillis(serviceInfo.getCacheMillis());
        return result;
    }

    @Deprecated
    private ServiceInfo handleClusterData(ServiceInfo data, Subscriber subscriber) {
        return StringUtils.isBlank((CharSequence)subscriber.getCluster()) ? data : ServiceUtil.selectInstances(data, subscriber.getCluster());
    }
}

