/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.executor;

import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.v2.PushDataWrapper;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutor;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutorRpcImpl;
import com.alibaba.nacos.naming.push.v2.executor.PushExecutorUdpImpl;
import com.alibaba.nacos.naming.push.v2.executor.SpiImplPushExecutorHolder;
import com.alibaba.nacos.naming.push.v2.executor.SpiPushExecutor;
import com.alibaba.nacos.naming.push.v2.task.NamingPushCallback;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class PushExecutorDelegate
implements PushExecutor {
    private final PushExecutorRpcImpl rpcPushExecuteService;
    private final PushExecutorUdpImpl udpPushExecuteService;

    public PushExecutorDelegate(PushExecutorRpcImpl rpcPushExecuteService, PushExecutorUdpImpl udpPushExecuteService) {
        this.rpcPushExecuteService = rpcPushExecuteService;
        this.udpPushExecuteService = udpPushExecuteService;
    }

    @Override
    public void doPush(String clientId, Subscriber subscriber, PushDataWrapper data) {
        this.getPushExecuteService(clientId, subscriber).doPush(clientId, subscriber, data);
    }

    @Override
    public void doPushWithCallback(String clientId, Subscriber subscriber, PushDataWrapper data, NamingPushCallback callBack) {
        this.getPushExecuteService(clientId, subscriber).doPushWithCallback(clientId, subscriber, data, callBack);
    }

    private PushExecutor getPushExecuteService(String clientId, Subscriber subscriber) {
        Optional<SpiPushExecutor> result = SpiImplPushExecutorHolder.getInstance().findPushExecutorSpiImpl(clientId, subscriber);
        if (result.isPresent()) {
            return result.get();
        }
        return clientId.contains("#") ? this.udpPushExecuteService : this.rpcPushExecuteService;
    }
}

