/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.model.form;

import com.alibaba.nacos.api.exception.api.NacosApiException;
import com.alibaba.nacos.api.model.v2.ErrorCode;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.http.HttpStatus;

public class ServiceForm
implements Serializable {
    private static final long serialVersionUID = -4905650083916616115L;
    private String namespaceId;
    private String serviceName;
    private String groupName;
    private Boolean ephemeral;
    private Float protectThreshold;
    private String metadata;
    private String selector;

    public void validate() throws NacosApiException {
        this.fillDefaultValue();
        if (StringUtils.isBlank((CharSequence)this.serviceName)) {
            throw new NacosApiException(HttpStatus.BAD_REQUEST.value(), ErrorCode.PARAMETER_MISSING, "Required parameter 'serviceName' type String is not present");
        }
    }

    public void fillDefaultValue() {
        if (StringUtils.isBlank((CharSequence)this.namespaceId)) {
            this.namespaceId = "public";
        }
        if (StringUtils.isBlank((CharSequence)this.groupName)) {
            this.groupName = "DEFAULT_GROUP";
        }
        if (this.ephemeral == null) {
            this.ephemeral = false;
        }
        if (this.protectThreshold == null) {
            this.protectThreshold = Float.valueOf(0.0f);
        }
        if (StringUtils.isBlank((CharSequence)this.metadata)) {
            this.metadata = "";
        }
        if (StringUtils.isBlank((CharSequence)this.selector)) {
            this.selector = "";
        }
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public Boolean getEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(Boolean ephemeral) {
        this.ephemeral = ephemeral;
    }

    public Float getProtectThreshold() {
        return this.protectThreshold;
    }

    public void setProtectThreshold(Float protectThreshold) {
        this.protectThreshold = protectThreshold;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceForm that = (ServiceForm)o;
        return Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.groupName, that.groupName) && Objects.equals(this.ephemeral, that.ephemeral) && Objects.equals(this.protectThreshold, that.protectThreshold) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.selector, that.selector);
    }

    public int hashCode() {
        return Objects.hash(this.namespaceId, this.serviceName, this.groupName, this.ephemeral, this.protectThreshold, this.metadata, this.selector);
    }

    public String toString() {
        return "ServiceForm{namespaceId='" + this.namespaceId + '\'' + ", serviceName='" + this.serviceName + '\'' + ", groupName='" + this.groupName + '\'' + ", ephemeral=" + this.ephemeral + ", protectThreshold=" + this.protectThreshold + ", metadata='" + this.metadata + '\'' + ", selector='" + this.selector + '\'' + '}';
    }
}

