/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.eureka;

import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.StatusChangeEvent;
import com.netflix.eventbus.spi.EventBus;
import com.netflix.eventbus.spi.InvalidSubscriberException;
import com.netflix.eventbus.spi.Subscribe;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusChangeEvent;
import com.netflix.spinnaker.kork.discovery.DiscoveryStatusPublisher;
import com.netflix.spinnaker.kork.discovery.InstanceStatus;
import com.netflix.spinnaker.kork.discovery.RemoteStatusChangedEvent;
import com.netflix.spinnaker.kork.eureka.InstanceStatusUtil;
import com.netflix.spinnaker.kork.exceptions.SystemException;
import java.util.Objects;
import javax.annotation.PreDestroy;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class EurekaStatusSubscriber
implements DiscoveryStatusPublisher {
    private final ApplicationEventPublisher publisher;
    private final EventBus eventBus;

    public EurekaStatusSubscriber(ApplicationEventPublisher publisher, EventBus eventBus, DiscoveryClient discoveryClient) {
        this.publisher = Objects.requireNonNull(publisher, "publisher");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.publish(new DiscoveryStatusChangeEvent(InstanceStatus.UNKNOWN, InstanceStatusUtil.fromEureka(discoveryClient.getInstanceRemoteStatus())));
        try {
            eventBus.registerSubscriber((Object)this);
        }
        catch (InvalidSubscriberException ise) {
            throw new SystemException((Throwable)ise);
        }
    }

    @PreDestroy
    public void shutdown() {
        this.eventBus.unregisterSubscriber((Object)this);
    }

    private void publish(DiscoveryStatusChangeEvent event) {
        this.publisher.publishEvent((ApplicationEvent)new RemoteStatusChangedEvent(event));
    }

    @Subscribe(name="eurekaStatusSubscriber")
    public void onStatusChange(StatusChangeEvent event) {
        this.publish(new DiscoveryStatusChangeEvent(InstanceStatusUtil.fromEureka(event.getPreviousStatus()), InstanceStatusUtil.fromEureka(event.getStatus())));
    }
}

