/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.eureka;

import java.util.Objects;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(value="eureka")
public class EurekaConfigurationProperties {
    @NestedConfigurationProperty
    private final Namespace instance = new Namespace("netflix.appinfo.");
    @NestedConfigurationProperty
    private final Namespace client = new Namespace("netflix.discovery.");

    public Namespace getInstance() {
        return this.instance;
    }

    public Namespace getClient() {
        return this.client;
    }

    public static class Namespace {
        private String namespace;

        public Namespace(String namespace) {
            this.namespace = Namespace.fixNamespace(namespace);
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = Namespace.fixNamespace(namespace);
        }

        private static String fixNamespace(String namespace) {
            Objects.requireNonNull(namespace, "namespace");
            return namespace.endsWith(".") ? namespace : namespace + ".";
        }
    }
}

