/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.kork.archaius;

import com.netflix.config.AbstractPollingScheduler;
import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicConfiguration;
import com.netflix.config.FixedDelayPollingScheduler;
import com.netflix.config.PolledConfigurationSource;
import com.netflix.spinnaker.kork.archaius.SpringEnvironmentPolledConfigurationSource;
import com.netflix.spinnaker.kork.eureka.EurekaAutoConfiguration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.CompositeConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"archaius.enabled"})
@AutoConfigureOrder(value=-2147483638)
@AutoConfigureBefore(value={EurekaAutoConfiguration.class})
public class ArchaiusAutoConfiguration {
    @Bean
    public static AbstractPollingScheduler pollingScheduler(ConfigurableApplicationContext applicationContext) {
        int initialDelayMillis = (Integer)applicationContext.getEnvironment().getProperty("archaius.fixedDelayPollingScheduler.initialDelayMills", Integer.class, (Object)0);
        int delayMillis = (Integer)applicationContext.getEnvironment().getProperty("archaius.fixedDelayPollingScheduler.delayMills", Integer.class, (Object)((int)TimeUnit.SECONDS.toMillis(15L)));
        return new FixedDelayPollingScheduler(initialDelayMillis, delayMillis, false);
    }

    @Bean
    public static SpringEnvironmentPolledConfigurationSource polledConfigurationSource(ConfigurableApplicationContext applicationContext) {
        return new SpringEnvironmentPolledConfigurationSource(applicationContext.getEnvironment());
    }

    @Bean
    public static ArchaiusInitializer archaiusInitializer(ConfigurableApplicationContext applicationContext, AbstractPollingScheduler pollingScheduler, SpringEnvironmentPolledConfigurationSource polledConfigurationSource) {
        return new ArchaiusInitializer(applicationContext, pollingScheduler, polledConfigurationSource);
    }

    static class ArchaiusInitializer
    implements BeanPostProcessor {
        private final AbstractPollingScheduler pollingScheduler;
        private final DynamicConfiguration configurationInstance;

        public ArchaiusInitializer(ConfigurableApplicationContext applicationContext, AbstractPollingScheduler pollingScheduler, SpringEnvironmentPolledConfigurationSource polledConfigurationSource) {
            Objects.requireNonNull(applicationContext, "applicationContext");
            this.pollingScheduler = Objects.requireNonNull(pollingScheduler, "pollingScheduler");
            Objects.requireNonNull(polledConfigurationSource, "polledConfigurationSource");
            DynamicConfiguration installedConfiguration = null;
            if (!ConfigurationManager.isConfigurationInstalled()) {
                installedConfiguration = new DynamicConfiguration((PolledConfigurationSource)polledConfigurationSource, pollingScheduler);
                CompositeConfiguration configuration = new CompositeConfiguration();
                configuration.addConfiguration((org.apache.commons.configuration.Configuration)installedConfiguration);
                ConfigurationManager.install((AbstractConfiguration)configuration);
            } else {
                pollingScheduler.stop();
            }
            this.configurationInstance = installedConfiguration;
            AbstractConfiguration config = ConfigurationManager.getConfigInstance();
            applicationContext.getBeanFactory().registerSingleton("environmentBackedConfig", (Object)config);
            applicationContext.getBeanFactory().registerAlias("environmentBackedConfig", "abstractConfiguration");
        }

        @PreDestroy
        public void shutdown() {
            if (this.configurationInstance != null) {
                this.pollingScheduler.stop();
                ((CompositeConfiguration)ConfigurationManager.getConfigInstance()).removeConfiguration((org.apache.commons.configuration.Configuration)this.configurationInstance);
            }
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

