package io.smallrye.jwt.util;

import java.util.Locale;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.io.UncheckedIOException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.lang.String;
import java.security.KeyStoreException;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class JWTUtilMessages_$bundle implements JWTUtilMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected JWTUtilMessages_$bundle() {}
    public static final JWTUtilMessages_$bundle INSTANCE = new JWTUtilMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidJWKSPublicKey$str() {
        return "Failed to decode the JWKS Public Key";
    }
    @Override
    public final UncheckedIOException invalidJWKSPublicKey(final IOException ioe) {
        final UncheckedIOException result = new UncheckedIOException(String.format(getLoggingLocale(), invalidJWKSPublicKey$str()), ioe);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String unsupportedAlgorithm$str() {
        return "SRJWT00001: Unsupported key type %s";
    }
    @Override
    public final NoSuchAlgorithmException unsupportedAlgorithm(final String algorithmName) {
        final NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(getLoggingLocale(), unsupportedAlgorithm$str(), algorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keyNotFound$str() {
        return "SRJWT00002: No resource with the named %s location exists";
    }
    @Override
    public final IOException keyNotFound(final String keyLocation) {
        final IOException result = new IOException(String.format(getLoggingLocale(), keyNotFound$str(), keyLocation));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requiresSymmetricAlgo$str() {
        return "SRJWT00003: Algorithm %s is not a symmetric-key algorithm";
    }
    @Override
    public final InvalidAlgorithmParameterException requiresSymmetricAlgo(final String algorithmName) {
        final InvalidAlgorithmParameterException result = new InvalidAlgorithmParameterException(String.format(getLoggingLocale(), requiresSymmetricAlgo$str(), algorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keystoreProviderNotFound$str() {
        return "SRJWT00004: Keystore provider %s is not found";
    }
    @Override
    public final KeyStoreException keystoreProviderNotFound(final String provider) {
        final KeyStoreException result = new KeyStoreException(String.format(getLoggingLocale(), keystoreProviderNotFound$str(), provider));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
