/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.datafetcher.AbstractDataFetcher;
import io.smallrye.graphql.execution.datafetcher.DataFetcherException;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.eclipse.microprofile.graphql.GraphQLException;

public abstract class AbstractStreamingDataFetcher<K, T>
extends AbstractDataFetcher<K, T> {
    public AbstractStreamingDataFetcher(Operation operation, Type type) {
        super(operation, type);
    }

    @Override
    protected <O> O invokeAndTransform(final Context context, final DataFetchingEnvironment dfe, final DataFetcherResult.Builder<Object> resultBuilder, Object[] transformedArguments) throws Exception {
        Multi multi = this.handleUserMethodCall(dfe, transformedArguments).onItem().transform(t -> {
            try {
                Object resultFromTransform = this.fieldHelper.transformOrAdaptResponse(t, dfe);
                resultBuilder.data(resultFromTransform);
                return resultBuilder.build();
            }
            catch (AbstractDataFetcherException abstractDataFetcherException) {
                abstractDataFetcherException.appendDataFetcherResult(resultBuilder, dfe);
                this.eventEmitter.fireOnDataFetchError(context, abstractDataFetcherException);
                return resultBuilder.build();
            }
        }).onFailure().recoverWithItem(new Function<Throwable, O>(){

            @Override
            public O apply(Throwable throwable) {
                AbstractStreamingDataFetcher.this.eventEmitter.fireOnDataFetchError(context, throwable);
                if (throwable instanceof GraphQLException) {
                    GraphQLException graphQLException = (GraphQLException)throwable;
                    AbstractStreamingDataFetcher.this.errorResultHelper.appendPartialResult((DataFetcherResult.Builder<Object>)resultBuilder, dfe, graphQLException);
                } else if (throwable instanceof Exception) {
                    DataFetcherException dataFetcherException = SmallRyeGraphQLServerMessages.msg.dataFetcherException(AbstractStreamingDataFetcher.this.operation, throwable);
                    AbstractStreamingDataFetcher.this.errorResultHelper.appendException((DataFetcherResult.Builder<Object>)resultBuilder, dfe, dataFetcherException);
                } else if (throwable instanceof Error) {
                    AbstractStreamingDataFetcher.this.errorResultHelper.appendException((DataFetcherResult.Builder<Object>)resultBuilder, dfe, throwable);
                }
                return resultBuilder.build();
            }
        });
        return (O)AdaptersToReactiveStreams.publisher((Flow.Publisher)multi);
    }

    protected abstract Multi<?> handleUserMethodCall(DataFetchingEnvironment var1, Object[] var2) throws Exception;

    @Override
    protected <O> O invokeFailure(DataFetcherResult.Builder<Object> resultBuilder) {
        return (O)Multi.createFrom().item(() -> resultBuilder.build());
    }

    @Override
    protected CompletionStage<List<T>> invokeBatch(DataFetchingEnvironment dfe, Object[] arguments) {
        try {
            return this.handleUserBatchLoad(dfe, arguments).toUni().runSubscriptionOn(Infrastructure.getDefaultExecutor()).subscribe().asCompletionStage();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract Multi<List<T>> handleUserBatchLoad(DataFetchingEnvironment var1, Object[] var2) throws Exception;
}

