package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

/**
 * Automatically generated from the {@link NonBlockingConfig} config interface, do not modify.
 */
public final class NonBlockingConfigImpl implements NonBlockingConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Description for the error message: a fully qualified method name.
     */
    private final String description;

    /**
     * Configuration key: either {@code <classname>/<methodname>} or {@code <classname>}.
     */
    private final String configKey;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final NonBlocking instance;

    private NonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(NonBlocking.class);
        this.description = method.method.toString();
        this.configKey = onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.nonBlocking;
    }

    public static NonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.nonBlocking == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled("non-blocking.enabled", "NonBlocking/enabled", method.method)) {
            return null;
        }
        return new NonBlockingConfigImpl(method);
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NonBlocking.class;
    }

    @Override
    public void materialize() {
    }

    @Override
    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @NonBlocking on " + description + ": " + reason);
    }

    @Override
    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @NonBlocking." + member + " on " + description + ": " + reason);
    }
}
