/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.api;

import io.smallrye.reactive.messaging.kafka.api.KafkaMessageMetadata;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class OutgoingKafkaRecordMetadata<K>
implements KafkaMessageMetadata<K> {
    private final String topic;
    private final K recordKey;
    private final int partition;
    private final Instant timestamp;
    private final Headers headers;

    public static <K> OutgoingKafkaRecordMetadataBuilder<K> builder() {
        return new OutgoingKafkaRecordMetadataBuilder();
    }

    protected OutgoingKafkaRecordMetadata(String topic, K key, int partition, Instant timestamp, Headers headers) {
        this.topic = topic;
        this.recordKey = key;
        this.partition = partition;
        this.timestamp = timestamp;
        this.headers = headers;
    }

    @Override
    public int getPartition() {
        return this.partition;
    }

    @Override
    public Instant getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public K getKey() {
        return this.recordKey;
    }

    public static class OutgoingKafkaRecordMetadataBuilder<K> {
        private String topic;
        private K recordKey;
        private int partition = -1;
        private Instant timestamp = null;
        private Headers headers;

        public OutgoingKafkaRecordMetadataBuilder<K> withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public OutgoingKafkaRecordMetadataBuilder<K> withKey(K recordKey) {
            this.recordKey = recordKey;
            return this;
        }

        public OutgoingKafkaRecordMetadataBuilder<K> withPartition(int partition) {
            this.partition = partition;
            return this;
        }

        public OutgoingKafkaRecordMetadataBuilder<K> withTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public OutgoingKafkaRecordMetadataBuilder<K> withHeaders(Headers headers) {
            this.headers = headers;
            return this;
        }

        public OutgoingKafkaRecordMetadataBuilder<K> withHeaders(List<RecordHeader> headers) {
            ArrayList<RecordHeader> iterable = new ArrayList<RecordHeader>(headers);
            return this.withHeaders((Headers)new RecordHeaders(iterable));
        }

        protected String getTopic() {
            return this.topic;
        }

        protected K getRecordKey() {
            return this.recordKey;
        }

        protected int getPartition() {
            return this.partition;
        }

        protected Instant getTimestamp() {
            return this.timestamp;
        }

        protected Headers getHeaders() {
            return this.headers;
        }

        public OutgoingKafkaRecordMetadata<K> build() {
            return new OutgoingKafkaRecordMetadata<K>(this.topic, this.recordKey, this.partition, this.timestamp, this.headers);
        }
    }
}

