package io.vertx.mutiny.ext.web.openapi;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.Handler;

/**
 * Interface representing an <a href="https://github.com/OAI/OpenAPI-Specification/blob/master/versions/3.0.1.md#operationObject">Operation</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.openapi.Operation original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.openapi.Operation.class)
public class Operation {

  public static final io.smallrye.mutiny.vertx.TypeArg<Operation> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Operation((io.vertx.ext.web.openapi.Operation) obj),
    Operation::getDelegate
  );

  private final io.vertx.ext.web.openapi.Operation delegate;
  
  public Operation(io.vertx.ext.web.openapi.Operation delegate) {
    this.delegate = delegate;
  }

  public Operation(Object delegate) {
    this.delegate = (io.vertx.ext.web.openapi.Operation)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Operation() {
    this.delegate = null;
  }

  public io.vertx.ext.web.openapi.Operation getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Operation that = (Operation) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param handler 
   * @return 
   */
  @Fluent
  private io.vertx.mutiny.ext.web.openapi.Operation __handler(Handler<io.vertx.mutiny.ext.web.RoutingContext> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.ext.web.openapi.Operation handler(java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler 
   * @return 
   */
  @Fluent
  private io.vertx.mutiny.ext.web.openapi.Operation __failureHandler(Handler<io.vertx.mutiny.ext.web.RoutingContext> handler) { 
    delegate.failureHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.ext.web.RoutingContext.newInstance((io.vertx.ext.web.RoutingContext)event)));
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.ext.web.openapi.Operation failureHandler(java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> handler) {
    return __failureHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param address 
   * @return 
   */
  @Fluent
  public io.vertx.mutiny.ext.web.openapi.Operation routeToEventBus(String address) { 
    delegate.routeToEventBus(address);
    return this;
  }

  /**
   * @param address 
   * @param options 
   * @return 
   */
  @Fluent
  public io.vertx.mutiny.ext.web.openapi.Operation routeToEventBus(String address, io.vertx.core.eventbus.DeliveryOptions options) { 
    delegate.routeToEventBus(address, options);
    return this;
  }

  /**
   * @return operationId of this operation
   */
  public String getOperationId() { 
    String ret = delegate.getOperationId();
    return ret;
  }

  /**
   * @return model of this operation
   */
  public JsonObject getOperationModel() { 
    JsonObject ret = delegate.getOperationModel();
    return ret;
  }

  /**
   * @return http method of this operation
   */
  public io.vertx.core.http.HttpMethod getHttpMethod() { 
    io.vertx.core.http.HttpMethod ret = delegate.getHttpMethod();
    return ret;
  }

  /**
   * @return path in OpenAPI style
   */
  public String getOpenAPIPath() { 
    String ret = delegate.getOpenAPIPath();
    return ret;
  }

  public static  Operation newInstance(io.vertx.ext.web.openapi.Operation arg) {
    return arg != null ? new Operation(arg) : null;
  }

}
