package io.vertx.mutiny.mysqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.function.Supplier;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.sqlclient.PoolOptions;
import java.util.List;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.core.Handler;

/**
 * A  of {@link io.vertx.mutiny.mysqlclient.MySQLConnection MySQL Connections}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLPool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mysqlclient.MySQLPool.class)
public class MySQLPool extends io.vertx.mutiny.sqlclient.Pool {

  public static final io.smallrye.mutiny.vertx.TypeArg<MySQLPool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MySQLPool((io.vertx.mysqlclient.MySQLPool) obj),
    MySQLPool::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLPool delegate;
  
  public MySQLPool(io.vertx.mysqlclient.MySQLPool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLPool(Object delegate) {
    super((io.vertx.mysqlclient.MySQLPool)delegate);
    this.delegate = (io.vertx.mysqlclient.MySQLPool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MySQLPool() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.mysqlclient.MySQLPool getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLPool that = (MySQLPool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(String connectionUri) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(connectionUri, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), connectionUri, options));
    return ret;
  }

  /**
   * @param database the options for the connection
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(io.vertx.mysqlclient.MySQLConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(database, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * @param databases the list of servers
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(List<io.vertx.mysqlclient.MySQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(databases, options));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.mysqlclient.MySQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), databases, options));
    return ret;
  }

  /**
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(String connectionUri) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(connectionUri));
    return ret;
  }

  /**
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(connectionUri, poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * @param connectOptions 
   * @param poolOptions the options for creating the backing pool
   * @return the client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mysqlclient.MySQLConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(connectOptions, poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  /**
   * @param vertx 
   * @param mySQLConnectOptions 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, List<io.vertx.mysqlclient.MySQLConnectOptions> mySQLConnectOptions, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(vertx.getDelegate(), mySQLConnectOptions, options));
    return ret;
  }

  /**
   * @param databases the list of databases
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(List<io.vertx.mysqlclient.MySQLConnectOptions> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(databases, options));
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.mysqlclient.MySQLPool __connectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  public io.vertx.mutiny.mysqlclient.MySQLPool connectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __connectHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLPool connectionProvider(Function<io.vertx.mutiny.core.Context, io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new java.util.function.Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 provider.apply(io.vertx.mutiny.core.Context.newInstance((io.vertx.core.Context)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  /**
   * @param databases the server supplier
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.mysqlclient.MySQLConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), options));
    return ret;
  }

  /**
   * @param vertx 
   * @param databases 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.mysqlclient.MySQLPool pool(io.vertx.mutiny.core.Vertx vertx, java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.mysqlclient.MySQLConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.mysqlclient.MySQLPool ret = io.vertx.mutiny.mysqlclient.MySQLPool.newInstance((io.vertx.mysqlclient.MySQLPool)io.vertx.mysqlclient.MySQLPool.pool(vertx.getDelegate(), () -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), options));
    return ret;
  }

  /**
   * @param vertx 
   * @param mySQLConnectOptions 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(io.vertx.mutiny.core.Vertx vertx, java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.mysqlclient.MySQLConnectOptions>> mySQLConnectOptions, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(vertx.getDelegate(), () -> io.smallrye.mutiny.vertx.UniHelper.toFuture(mySQLConnectOptions.get()), options));
    return ret;
  }

  /**
   * @param databases the databases supplier
   * @param options the options for creating the pool
   * @return the pooled client
   */
  public static io.vertx.mutiny.sqlclient.SqlClient client(java.util.function.Supplier<io.smallrye.mutiny.Uni<io.vertx.mysqlclient.MySQLConnectOptions>> databases, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.SqlClient ret = io.vertx.mutiny.sqlclient.SqlClient.newInstance((io.vertx.sqlclient.SqlClient)io.vertx.mysqlclient.MySQLPool.client(() -> io.smallrye.mutiny.vertx.UniHelper.toFuture(databases.get()), options));
    return ret;
  }

  public static  MySQLPool newInstance(io.vertx.mysqlclient.MySQLPool arg) {
    return arg != null ? new MySQLPool(arg) : null;
  }

}
