package io.vertx.mutiny.mysqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Future;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mysqlclient.MySQLSetOption;

/**
 * An interface which represents a connection to MySQL server.
 * <P>
 *   The connection object supports all the operations defined in the  interface,
 *   in addition it provides MySQL utility command support:
 *   <ul>
 *     <li>COM_PING</li>
 *     <li>COM_CHANGE_USER</li>
 *     <li>COM_RESET_CONNECTION</li>
 *     <li>COM_DEBUG</li>
 *     <li>COM_INIT_DB</li>
 *     <li>COM_STATISTICS</li>
 *     <li>COM_SET_OPTION</li>
 *   </ul>
 * </P>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLConnection original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection extends io.vertx.mutiny.sqlclient.SqlConnection {

  public static final io.smallrye.mutiny.vertx.TypeArg<MySQLConnection> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection) obj),
    MySQLConnection::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLConnection delegate;
  
  public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLConnection(Object delegate) {
    super((io.vertx.mysqlclient.MySQLConnection)delegate);
    this.delegate = (io.vertx.mysqlclient.MySQLConnection)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  MySQLConnection() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.mysqlclient.MySQLConnection getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLConnection that = (MySQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.mysqlclient.MySQLConnection> connect(io.vertx.mutiny.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectOptions, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,MySQLConnectOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return the MySQLConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.mysqlclient.MySQLConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    return (io.vertx.mutiny.mysqlclient.MySQLConnection) connect(vertx, connectOptions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,MySQLConnectOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,MySQLConnectOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,MySQLConnectOptions)} but you don't need to compose it with other operations.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    connect(vertx, connectOptions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect} with options built from <code>connectionUri</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param vertx 
   * @param connectionUri 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public static io.smallrye.mutiny.Uni<io.vertx.mutiny.mysqlclient.MySQLConnection> connect(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectionUri, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param vertx 
   * @param connectionUri 
   * @return the MySQLConnection instance produced by the operation.
   */
  public static io.vertx.mutiny.mysqlclient.MySQLConnection connectAndAwait(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    return (io.vertx.mutiny.mysqlclient.MySQLConnection) connect(vertx, connectionUri).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#connect(io.vertx.mutiny.core.Vertx,String)} but you don't need to compose it with other operations.
   * @param vertx 
   * @param connectionUri 
   */
  public static void connectAndForget(io.vertx.mutiny.core.Vertx vertx, String connectionUri) { 
    connect(vertx, connectionUri).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * 
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param sql 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.PreparedStatement> prepare(String sql) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.prepare(sql, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#prepare(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param sql 
   * @return the PreparedStatement instance produced by the operation.
   */
  public io.vertx.mutiny.sqlclient.PreparedStatement prepareAndAwait(String sql) { 
    return (io.vertx.mutiny.sqlclient.PreparedStatement) prepare(sql).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#prepare(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#prepare(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#prepare(String)} but you don't need to compose it with other operations.
   * @param sql 
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection prepareAndForget(String sql) { 
    prepare(sql).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler 
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.mysqlclient.MySQLConnection __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.mysqlclient.MySQLConnection exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler 
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  private io.vertx.mutiny.mysqlclient.MySQLConnection __closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * @param handler 
   * @return 
   */
  public io.vertx.mutiny.mysqlclient.MySQLConnection closeHandler(java.lang.Runnable handler) {
    return __closeHandler(ignored -> handler.run()
);
  }

  /**
   * Send a PING command to check if the server is alive.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> ping() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.ping(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#ping}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void pingAndAwait() { 
    return (Void) ping().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#ping} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#ping}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#ping} but you don't need to compose it with other operations.
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection pingAndForget() { 
    ping().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param schemaName name of the schema to change to
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> specifySchema(String schemaName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.specifySchema(schemaName, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#specifySchema(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param schemaName name of the schema to change to
   * @return the Void instance produced by the operation.
   */
  public Void specifySchemaAndAwait(String schemaName) { 
    return (Void) specifySchema(schemaName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#specifySchema(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#specifySchema(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#specifySchema(String)} but you don't need to compose it with other operations.
   * @param schemaName name of the schema to change to
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection specifySchemaAndForget(String schemaName) { 
    specifySchema(schemaName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<String> getInternalStatistics() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getInternalStatistics(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#getInternalStatistics}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the String instance produced by the operation.
   */
  public String getInternalStatisticsAndAwait() { 
    return (String) getInternalStatistics().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#getInternalStatistics} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#getInternalStatistics}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#getInternalStatistics} but you don't need to compose it with other operations.
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection getInternalStatisticsAndForget() { 
    getInternalStatistics().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param option the options to set
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> setOption(io.vertx.mysqlclient.MySQLSetOption option) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.setOption(option, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#setOption(MySQLSetOption)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param option the options to set
   * @return the Void instance produced by the operation.
   */
  public Void setOptionAndAwait(io.vertx.mysqlclient.MySQLSetOption option) { 
    return (Void) setOption(option).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#setOption(MySQLSetOption)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#setOption(MySQLSetOption)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#setOption(MySQLSetOption)} but you don't need to compose it with other operations.
   * @param option the options to set
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection setOptionAndForget(io.vertx.mysqlclient.MySQLSetOption option) { 
    setOption(option).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> resetConnection() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.resetConnection(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#resetConnection}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void resetConnectionAndAwait() { 
    return (Void) resetConnection().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#resetConnection} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#resetConnection}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#resetConnection} but you don't need to compose it with other operations.
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection resetConnectionAndForget() { 
    resetConnection().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> debug() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.debug(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#debug}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void debugAndAwait() { 
    return (Void) debug().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#debug} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#debug}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#debug} but you don't need to compose it with other operations.
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection debugAndForget() { 
    debug().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options authentication options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> changeUser(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.changeUser(options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#changeUser(MySQLAuthOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options authentication options
   * @return the Void instance produced by the operation.
   */
  public Void changeUserAndAwait(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    return (Void) changeUser(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#changeUser(MySQLAuthOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.mysqlclient.MySQLConnection#changeUser(MySQLAuthOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.mysqlclient.MySQLConnection#changeUser(MySQLAuthOptions)} but you don't need to compose it with other operations.
   * @param options authentication options
   * @return the instance of MySQLConnection to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.mysqlclient.MySQLConnection changeUserAndForget(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    changeUser(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param sqlConnection the connection to cast
   * @return a {@link io.vertx.mutiny.mysqlclient.MySQLConnection instance}
   */
  public static io.vertx.mutiny.mysqlclient.MySQLConnection cast(io.vertx.mutiny.sqlclient.SqlConnection sqlConnection) { 
    io.vertx.mutiny.mysqlclient.MySQLConnection ret = io.vertx.mutiny.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)io.vertx.mysqlclient.MySQLConnection.cast(sqlConnection.getDelegate()));
    return ret;
  }

  public static  MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
    return arg != null ? new MySQLConnection(arg) : null;
  }

}
