package io.vertx.mutiny.kafka.client.consumer;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.kafka.client.common.KafkaClientOptions;
import io.vertx.kafka.client.consumer.OffsetAndMetadata;
import java.util.Set;
import io.vertx.kafka.client.common.PartitionInfo;
import io.vertx.core.Future;
import io.vertx.kafka.client.common.TopicPartition;
import java.util.List;
import java.util.Map;
import java.time.Duration;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.kafka.client.consumer.OffsetAndTimestamp;

/**
 * Vert.x Kafka consumer.
 * <p>
 * You receive Kafka records by providing a {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#handler}. As messages arrive the handler
 * will be called with the records.
 * <p>
 * The {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume} provides global control over reading the records from the consumer.
 * <p>
 * The {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause} and {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume} provides finer grained control over reading records
 * for specific Topic/Partition, these are Kafka's specific operations.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.kafka.client.consumer.KafkaConsumer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.kafka.client.consumer.KafkaConsumer.class)
public class KafkaConsumer<K,V> implements io.vertx.mutiny.core.streams.ReadStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> {

  public static final io.smallrye.mutiny.vertx.TypeArg<KafkaConsumer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new KafkaConsumer((io.vertx.kafka.client.consumer.KafkaConsumer) obj),
    KafkaConsumer::getDelegate
  );

  private final io.vertx.kafka.client.consumer.KafkaConsumer<K,V> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_0;
  public final io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_1;
  
  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public KafkaConsumer(Object delegate, TypeArg<K> typeArg_0, TypeArg<V> typeArg_1) {
    this.delegate = (io.vertx.kafka.client.consumer.KafkaConsumer)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  public KafkaConsumer(io.vertx.kafka.client.consumer.KafkaConsumer delegate, io.smallrye.mutiny.vertx.TypeArg<K> typeArg_0, io.smallrye.mutiny.vertx.TypeArg<V> typeArg_1) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  KafkaConsumer() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();    this.__typeArg_1 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.kafka.client.consumer.KafkaConsumer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    KafkaConsumer that = (KafkaConsumer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> pipe() { 
    io.vertx.mutiny.core.streams.Pipe<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> ret = io.vertx.mutiny.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), new TypeArg<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K,V>>(o0 -> io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)o0, __typeArg_0, __typeArg_1), o0 -> o0.getDelegate()));
    return ret;
  }

  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pipeTo(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.pipeTo(dst.getDelegate(), handler);
    });
  }

  public Void pipeToAndAwait(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst) { 
    return (Void) pipeTo(dst).await().indefinitely();
  }

  public void pipeToAndForget(io.vertx.mutiny.core.streams.WriteStream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> dst) { 
    pipeTo(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> create(io.vertx.mutiny.core.Vertx vertx, java.util.Map<String, String> config) { 
    io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> ret = io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param config Kafka consumer configuration
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> create(io.vertx.mutiny.core.Vertx vertx, java.util.Map<String, String> config, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> ret = io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), config, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param options Kafka consumer options
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> create(io.vertx.mutiny.core.Vertx vertx, io.vertx.kafka.client.common.KafkaClientOptions options) { 
    io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> ret = io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), options), TypeArg.unknown(), TypeArg.unknown());
    return ret;
  }

  /**
   * @param vertx Vert.x instance to use
   * @param options Kafka consumer options
   * @param keyType class type for the key deserialization
   * @param valueType class type for the value deserialization
   * @return an instance of the KafkaConsumer
   */
  public static <K, V> io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> create(io.vertx.mutiny.core.Vertx vertx, io.vertx.kafka.client.common.KafkaClientOptions options, java.lang.Class<K> keyType, java.lang.Class<V> valueType) { 
    io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> ret = io.vertx.mutiny.kafka.client.consumer.KafkaConsumer.newInstance((io.vertx.kafka.client.consumer.KafkaConsumer)io.vertx.kafka.client.consumer.KafkaConsumer.create(vertx.getDelegate(), options, io.smallrye.mutiny.vertx.MutinyHelper.unwrap(keyType), io.smallrye.mutiny.vertx.MutinyHelper.unwrap(valueType)), io.smallrye.mutiny.vertx.TypeArg.of(keyType), io.smallrye.mutiny.vertx.TypeArg.of(valueType));
    return ret;
  }

  @Fluent
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> exceptionHandler(java.util.function.Consumer<java.lang.Throwable> handler) {
    return __exceptionHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __handler(Handler<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> handler) { 
    delegate.handler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecord)event, __typeArg_0, __typeArg_1)));
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> handler(java.util.function.Consumer<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> handler) {
    return __handler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pause() { 
    delegate.pause();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> resume() { 
    delegate.resume();
    return this;
  }

  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  @Fluent
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> endHandler(java.lang.Runnable endHandler) {
    return __endHandler(ignored -> endHandler.run()
);
  }

  /**
   * @return current demand
   */
  public long demand() { 
    long ret = delegate.demand();
    return ret;
  }

  /**
   * Subscribe to the given topic to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topic
   * the old topic may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic to subscribe to
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> subscribe(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.subscribe(topic, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic to subscribe to
   * @return the Void instance produced by the operation.
   */
  public Void subscribeAndAwait(String topic) { 
    return (Void) subscribe(topic).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(String)} but you don't need to compose it with other operations.
   * @param topic topic to subscribe to
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> subscribeAndForget(String topic) { 
    subscribe(topic).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Subscribe to the given list of topics to get dynamically assigned partitions.
   * <p>
   * Due to internal buffering of messages, when changing the subscribed topics
   * the old set of topics may remain in effect
   * (as observed by the  record handler})
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of topics.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topics topics to subscribe to
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> subscribe(Set<String> topics) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.subscribe(topics, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topics topics to subscribe to
   * @return the Void instance produced by the operation.
   */
  public Void subscribeAndAwait(Set<String> topics) { 
    return (Void) subscribe(topics).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscribe(Set)} but you don't need to compose it with other operations.
   * @param topics topics to subscribe to
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> subscribeAndForget(Set<String> topics) { 
    subscribe(topics).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Manually assign a partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old partition may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new partition.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition partition which want assigned
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> assign(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.assign(topicPartition, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition partition which want assigned
   * @return the Void instance produced by the operation.
   */
  public Void assignAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Void) assign(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition partition which want assigned
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> assignAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    assign(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Manually assign a list of partition to this consumer.
   * <p>
   * Due to internal buffering of messages, when reassigning
   * the old set of partitions may remain in effect
   * (as observed by the  record handler)}
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new set of partitions.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions partitions which want assigned
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> assign(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.assign(topicPartitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions partitions which want assigned
   * @return the Void instance produced by the operation.
   */
  public Void assignAndAwait(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return (Void) assign(topicPartitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assign(Set)} but you don't need to compose it with other operations.
   * @param topicPartitions partitions which want assigned
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> assignAndForget(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    assign(topicPartitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the set of partitions currently assigned to this consumer.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Set<io.vertx.kafka.client.common.TopicPartition>> assignment() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.assignment(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assignment}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<TopicPartition> instance produced by the operation.
   */
  public Set<io.vertx.kafka.client.common.TopicPartition> assignmentAndAwait() { 
    return (Set<io.vertx.kafka.client.common.TopicPartition>) assignment().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assignment} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assignment}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#assignment} but you don't need to compose it with other operations.
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> assignmentAndForget() { 
    assignment().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Unsubscribe from topics currently subscribed with subscribe.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> unsubscribe() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.unsubscribe(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void unsubscribeAndAwait() { 
    return (Void) unsubscribe().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#unsubscribe} but you don't need to compose it with other operations.
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> unsubscribeAndForget() { 
    unsubscribe().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the current subscription.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Set<String>> subscription() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.subscription(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscription}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<String> instance produced by the operation.
   */
  public Set<String> subscriptionAndAwait() { 
    return (Set<String>) subscription().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscription} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscription}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#subscription} but you don't need to compose it with other operations.
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> subscriptionAndForget() { 
    subscription().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Suspend fetching from the requested partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartition</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartition</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition from which suspend fetching
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pause(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.pause(topicPartition, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition from which suspend fetching
   * @return the Void instance produced by the operation.
   */
  public Void pauseAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Void) pause(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition from which suspend fetching
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pauseAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    pause(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Suspend fetching from the requested partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages from the given <code>topicPartitions</code>
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will not see messages
   * from the given <code>topicPartitions</code>.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition from which suspend fetching
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> pause(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.pause(topicPartitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition from which suspend fetching
   * @return the Void instance produced by the operation.
   */
  public Void pauseAndAwait(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return (Void) pause(topicPartitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#pause(Set)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition from which suspend fetching
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pauseAndForget(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    pause(topicPartitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Get the set of partitions that were previously paused by a call to pause(Set).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Set<io.vertx.kafka.client.common.TopicPartition>> paused() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.paused(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#paused}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Set<TopicPartition> instance produced by the operation.
   */
  public Set<io.vertx.kafka.client.common.TopicPartition> pausedAndAwait() { 
    return (Set<io.vertx.kafka.client.common.TopicPartition>) paused().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#paused} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#paused}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#paused} but you don't need to compose it with other operations.
   */
  public void pausedAndForget() { 
    paused().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Resume specified partition which have been paused with pause.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition from which resume fetching
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> resume(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.resume(topicPartition, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition from which resume fetching
   * @return the Void instance produced by the operation.
   */
  public Void resumeAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Void) resume(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition from which resume fetching
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> resumeAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    resume(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Resume specified partitions which have been paused with pause.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition from which resume fetching
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> resume(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.resume(topicPartitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition from which resume fetching
   * @return the Void instance produced by the operation.
   */
  public Void resumeAndAwait(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return (Void) resume(topicPartitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#resume(Set)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition from which resume fetching
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> resumeAndForget(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    resume(topicPartitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler handler called on revoked topic partitions
   * @return current KafkaConsumer instance
   */
  @Fluent
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __partitionsRevokedHandler(Handler<Set<io.vertx.kafka.client.common.TopicPartition>> handler) { 
    delegate.partitionsRevokedHandler(handler);
    return this;
  }

  /**
   * @param handler handler called on revoked topic partitions
   * @return 
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> partitionsRevokedHandler(java.util.function.Consumer<Set<io.vertx.kafka.client.common.TopicPartition>> handler) {
    return __partitionsRevokedHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param handler handler called on assigned topic partitions
   * @return current KafkaConsumer instance
   */
  @Fluent
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __partitionsAssignedHandler(Handler<Set<io.vertx.kafka.client.common.TopicPartition>> handler) { 
    delegate.partitionsAssignedHandler(handler);
    return this;
  }

  /**
   * @param handler handler called on assigned topic partitions
   * @return 
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> partitionsAssignedHandler(java.util.function.Consumer<Set<io.vertx.kafka.client.common.TopicPartition>> handler) {
    return __partitionsAssignedHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * Overrides the fetch offsets that the consumer will use on the next poll.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> seek(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.seek(topicPartition, offset, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return the Void instance produced by the operation.
   */
  public Void seekAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    return (Void) seek(topicPartition, offset).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seek(TopicPartition,long)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for which seek
   * @param offset offset to seek inside the topic partition
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition, long offset) { 
    seek(topicPartition, offset).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for which seek
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> seekToBeginning(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.seekToBeginning(topicPartition, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for which seek
   * @return the Void instance produced by the operation.
   */
  public Void seekToBeginningAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Void) seekToBeginning(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for which seek
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToBeginningAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    seekToBeginning(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Seek to the first offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition for which seek
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> seekToBeginning(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.seekToBeginning(topicPartitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition for which seek
   * @return the Void instance produced by the operation.
   */
  public Void seekToBeginningAndAwait(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return (Void) seekToBeginning(topicPartitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToBeginning(Set)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition for which seek
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToBeginningAndForget(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    seekToBeginning(topicPartitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partition.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for which seek
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> seekToEnd(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.seekToEnd(topicPartition, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for which seek
   * @return the Void instance produced by the operation.
   */
  public Void seekToEndAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Void) seekToEnd(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for which seek
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToEndAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    seekToEnd(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Seek to the last offset for each of the given partitions.
   * <p>
   * Due to internal buffering of messages,
   * the  will
   * continue to observe messages fetched with respect to the old offset
   * until some time <em>after</em> the given <code>completionHandler</code>
   * is called. In contrast, the once the given <code>completionHandler</code>
   * is called the {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#batchHandler} will only see messages
   * consistent with the new offset.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartitions topic partition for which seek
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> seekToEnd(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.seekToEnd(topicPartitions, completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartitions topic partition for which seek
   * @return the Void instance produced by the operation.
   */
  public Void seekToEndAndAwait(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    return (Void) seekToEnd(topicPartitions).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#seekToEnd(Set)} but you don't need to compose it with other operations.
   * @param topicPartitions topic partition for which seek
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> seekToEndAndForget(Set<io.vertx.kafka.client.common.TopicPartition> topicPartitions) { 
    seekToEnd(topicPartitions).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Commit current offsets for all the subscribed list of topics and partition.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> commit() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.commit(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void commitAndAwait() { 
    return (Void) commit().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#commit} but you don't need to compose it with other operations.
   */
  public void commitAndForget() { 
    commit().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the last committed offset for the given partition (whether the commit happened by this process or another).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition topic partition for getting last committed offset
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.kafka.client.consumer.OffsetAndMetadata> committed(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.committed(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#committed(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition topic partition for getting last committed offset
   * @return the OffsetAndMetadata instance produced by the operation.
   */
  public io.vertx.kafka.client.consumer.OffsetAndMetadata committedAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (io.vertx.kafka.client.consumer.OffsetAndMetadata) committed(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#committed(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#committed(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#committed(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition topic partition for getting last committed offset
   */
  public void committedAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    committed(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get metadata about the partitions for a given topic.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topic topic partition for which getting partitions info
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<List<io.vertx.kafka.client.common.PartitionInfo>> partitionsFor(String topic) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.partitionsFor(topic, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#partitionsFor(String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topic topic partition for which getting partitions info
   * @return the List<PartitionInfo> instance produced by the operation.
   */
  public List<io.vertx.kafka.client.common.PartitionInfo> partitionsForAndAwait(String topic) { 
    return (List<io.vertx.kafka.client.common.PartitionInfo>) partitionsFor(topic).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#partitionsFor(String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#partitionsFor(String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#partitionsFor(String)} but you don't need to compose it with other operations.
   * @param topic topic partition for which getting partitions info
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> partitionsForAndForget(String topic) { 
    partitionsFor(topic).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * @param handler handler called when batches of messages are fetched
   * @return current KafkaConsumer instance
   */
  @Fluent
  private io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> __batchHandler(Handler<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> handler) { 
    delegate.batchHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecords)event, __typeArg_0, __typeArg_1)));
    return this;
  }

  /**
   * @param handler handler called when batches of messages are fetched
   * @return 
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> batchHandler(java.util.function.Consumer<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> handler) {
    return __batchHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * Close the consumer
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.close(completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the offset of the next record that will be fetched (if a record with that offset exists).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param partition The partition to get the position for
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> position(io.vertx.kafka.client.common.TopicPartition partition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.position(partition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#position(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param partition The partition to get the position for
   * @return the Long instance produced by the operation.
   */
  public Long positionAndAwait(io.vertx.kafka.client.common.TopicPartition partition) { 
    return (Long) position(partition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#position(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#position(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#position(TopicPartition)} but you don't need to compose it with other operations.
   * @param partition The partition to get the position for
   */
  public void positionAndForget(io.vertx.kafka.client.common.TopicPartition partition) { 
    position(partition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Look up the offset for the given partition by timestamp. Note: the result might be null in case
   * for the given timestamp no offset can be found -- e.g., when the timestamp refers to the future
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.kafka.client.consumer.OffsetAndTimestamp> offsetsForTimes(io.vertx.kafka.client.common.TopicPartition topicPartition, Long timestamp) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.offsetsForTimes(topicPartition, timestamp, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#offsetsForTimes(TopicPartition,Long)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   * @return the OffsetAndTimestamp instance produced by the operation.
   */
  public io.vertx.kafka.client.consumer.OffsetAndTimestamp offsetsForTimesAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition, Long timestamp) { 
    return (io.vertx.kafka.client.consumer.OffsetAndTimestamp) offsetsForTimes(topicPartition, timestamp).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#offsetsForTimes(TopicPartition,Long)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#offsetsForTimes(TopicPartition,Long)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#offsetsForTimes(TopicPartition,Long)} but you don't need to compose it with other operations.
   * @param topicPartition TopicPartition to query.
   * @param timestamp Timestamp to be used in the query.
   */
  public void offsetsForTimesAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition, Long timestamp) { 
    offsetsForTimes(topicPartition, timestamp).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the first offset for the given partitions.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition the partition to get the earliest offset.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> beginningOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.beginningOffsets(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#beginningOffsets(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition the partition to get the earliest offset.
   * @return the Long instance produced by the operation.
   */
  public Long beginningOffsetsAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Long) beginningOffsets(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#beginningOffsets(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#beginningOffsets(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#beginningOffsets(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition the partition to get the earliest offset.
   */
  public void beginningOffsetsAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    beginningOffsets(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get the last offset for the given partition. The last offset of a partition is the offset
   * of the upcoming message, i.e. the offset of the last available message + 1.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param topicPartition the partition to get the end offset.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Long> endOffsets(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.endOffsets(topicPartition, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#endOffsets(TopicPartition)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param topicPartition the partition to get the end offset.
   * @return the Long instance produced by the operation.
   */
  public Long endOffsetsAndAwait(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    return (Long) endOffsets(topicPartition).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#endOffsets(TopicPartition)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#endOffsets(TopicPartition)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#endOffsets(TopicPartition)} but you don't need to compose it with other operations.
   * @param topicPartition the partition to get the end offset.
   */
  public void endOffsetsAndForget(io.vertx.kafka.client.common.TopicPartition topicPartition) { 
    endOffsets(topicPartition).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param timeout The time, spent waiting in poll if data is not available in the buffer. If 0, returns immediately with any records that are available currently in the native Kafka consumer's buffer, else returns empty. Must not be negative.
   * @return the instance of KafkaConsumer<K,V> to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumer<K, V> pollTimeout(java.time.Duration timeout) { 
    delegate.pollTimeout(timeout);
    return this;
  }

  /**
   * Executes a poll for getting messages from Kafka.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>> poll(java.time.Duration timeout) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.poll(timeout, new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords.newInstance((io.vertx.kafka.client.consumer.KafkaConsumerRecords)event, __typeArg_0, __typeArg_1))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#poll(Duration)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   * @return the KafkaConsumerRecords<K,V> instance produced by the operation.
   */
  public io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V> pollAndAwait(java.time.Duration timeout) { 
    return (io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecords<K, V>) poll(timeout).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#poll(Duration)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#poll(Duration)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.kafka.client.consumer.KafkaConsumer#poll(Duration)} but you don't need to compose it with other operations.
   * @param timeout The maximum time to block (must not be greater than {@link java.lang.Long} milliseconds)
   */
  public void pollAndForget(java.time.Duration timeout) { 
    poll(timeout).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  private Multi<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> multi;

  @CheckReturnValue
  public synchronized Multi<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> toMulti() {
    if (multi == null) {
      java.util.function.Function<io.vertx.kafka.client.consumer.KafkaConsumerRecord<K,V>, io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> conv = io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord::newInstance;
      multi = io.smallrye.mutiny.vertx.MultiHelper.toMulti(delegate, conv);    }
    return multi;
  }

  public java.lang.Iterable<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> toBlockingIterable() {
    return toMulti().subscribe().asIterable();
  }

  public java.util.stream.Stream<io.vertx.mutiny.kafka.client.consumer.KafkaConsumerRecord<K, V>> toBlockingStream() {
    return toMulti().subscribe().asStream();
  }

  public static <K,V>KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg) {
    return arg != null ? new KafkaConsumer<K,V>(arg) : null;
  }


  public static <K,V>KafkaConsumer<K,V> newInstance(io.vertx.kafka.client.consumer.KafkaConsumer arg, io.smallrye.mutiny.vertx.TypeArg<K> __typeArg_K, io.smallrye.mutiny.vertx.TypeArg<V> __typeArg_V) {
    return arg != null ? new KafkaConsumer<K,V>(arg, __typeArg_K, __typeArg_V) : null;
  }

}
