package io.vertx.mutiny.ext.auth.jwt.authorization;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Implementation of the JWT authorization provider.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jwt.authorization.JWTAuthorization original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.jwt.authorization.JWTAuthorization.class)
public class JWTAuthorization extends io.vertx.mutiny.ext.auth.authorization.AuthorizationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<JWTAuthorization> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JWTAuthorization((io.vertx.ext.auth.jwt.authorization.JWTAuthorization) obj),
    JWTAuthorization::getDelegate
  );

  private final io.vertx.ext.auth.jwt.authorization.JWTAuthorization delegate;
  
  public JWTAuthorization(io.vertx.ext.auth.jwt.authorization.JWTAuthorization delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JWTAuthorization(Object delegate) {
    super((io.vertx.ext.auth.jwt.authorization.JWTAuthorization)delegate);
    this.delegate = (io.vertx.ext.auth.jwt.authorization.JWTAuthorization)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JWTAuthorization() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.jwt.authorization.JWTAuthorization getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuthorization that = (JWTAuthorization) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param rootClaim slash separated string to the json array with the claims.
   * @return a AuthorizationProvider
   */
  public static io.vertx.mutiny.ext.auth.jwt.authorization.JWTAuthorization create(String rootClaim) { 
    io.vertx.mutiny.ext.auth.jwt.authorization.JWTAuthorization ret = io.vertx.mutiny.ext.auth.jwt.authorization.JWTAuthorization.newInstance((io.vertx.ext.auth.jwt.authorization.JWTAuthorization)io.vertx.ext.auth.jwt.authorization.JWTAuthorization.create(rootClaim));
    return ret;
  }

  public static  JWTAuthorization newInstance(io.vertx.ext.auth.jwt.authorization.JWTAuthorization arg) {
    return arg != null ? new JWTAuthorization(arg) : null;
  }

}
