package io.vertx.mutiny.ext.auth.jwt;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.jwt.JWTAuthOptions;

/**
 * Factory interface for creating JWT based {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jwt.JWTAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.jwt.JWTAuth.class)
public class JWTAuth extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<JWTAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JWTAuth((io.vertx.ext.auth.jwt.JWTAuth) obj),
    JWTAuth::getDelegate
  );

  private final io.vertx.ext.auth.jwt.JWTAuth delegate;
  
  public JWTAuth(io.vertx.ext.auth.jwt.JWTAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JWTAuth(Object delegate) {
    super((io.vertx.ext.auth.jwt.JWTAuth)delegate);
    this.delegate = (io.vertx.ext.auth.jwt.JWTAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JWTAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.jwt.JWTAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTAuth that = (JWTAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the Vertx instance
   * @param config the config
   * @return the auth provider
   */
  public static io.vertx.mutiny.ext.auth.jwt.JWTAuth create(io.vertx.mutiny.core.Vertx vertx, io.vertx.ext.auth.jwt.JWTAuthOptions config) { 
    io.vertx.mutiny.ext.auth.jwt.JWTAuth ret = io.vertx.mutiny.ext.auth.jwt.JWTAuth.newInstance((io.vertx.ext.auth.jwt.JWTAuth)io.vertx.ext.auth.jwt.JWTAuth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * @param claims Json with user defined claims for a list of official claims
   * @param options extra options for the generation
   * @return JWT encoded token
   */
  public String generateToken(JsonObject claims, io.vertx.ext.auth.JWTOptions options) { 
    String ret = delegate.generateToken(claims, options);
    return ret;
  }

  /**
   * @param claims Json with user defined claims for a list of official claims
   * @return JWT encoded token
   */
  public String generateToken(JsonObject claims) { 
    String ret = delegate.generateToken(claims);
    return ret;
  }

  public static  JWTAuth newInstance(io.vertx.ext.auth.jwt.JWTAuth arg) {
    return arg != null ? new JWTAuth(arg) : null;
  }

}
