package io.vertx.mutiny.ext.auth.jdbc;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCUserUtil original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.jdbc.JDBCUserUtil.class)
public class JDBCUserUtil {

  public static final io.smallrye.mutiny.vertx.TypeArg<JDBCUserUtil> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JDBCUserUtil((io.vertx.ext.auth.jdbc.JDBCUserUtil) obj),
    JDBCUserUtil::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCUserUtil delegate;
  
  public JDBCUserUtil(io.vertx.ext.auth.jdbc.JDBCUserUtil delegate) {
    this.delegate = delegate;
  }

  public JDBCUserUtil(Object delegate) {
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCUserUtil)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JDBCUserUtil() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.jdbc.JDBCUserUtil getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCUserUtil that = (JDBCUserUtil) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param client the client with write rights to the database.
   * @return the instance
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil create(io.vertx.mutiny.ext.jdbc.JDBCClient client) { 
    io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil ret = io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil.newInstance((io.vertx.ext.auth.jdbc.JDBCUserUtil)io.vertx.ext.auth.jdbc.JDBCUserUtil.create(client.getDelegate()));
    return ret;
  }

  /**
   * @param client the client with write rights to the database.
   * @param insertUserSQL 
   * @param insertUserRoleSQL 
   * @param insertRolePermissionSQL 
   * @return the instance
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil create(io.vertx.mutiny.ext.jdbc.JDBCClient client, String insertUserSQL, String insertUserRoleSQL, String insertRolePermissionSQL) { 
    io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil ret = io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil.newInstance((io.vertx.ext.auth.jdbc.JDBCUserUtil)io.vertx.ext.auth.jdbc.JDBCUserUtil.create(client.getDelegate(), insertUserSQL, insertUserRoleSQL, insertRolePermissionSQL));
    return ret;
  }

  /**
   * Insert a user into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Void> createUser(String username, String password) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createUser(username, password, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUser(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return the Void instance produced by the operation.
   * @deprecated   */
  @Deprecated
  public Void createUserAndAwait(String username, String password) { 
    return (Void) createUser(username, password).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUser(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUser(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUser(String,String)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param password the passsword in clear text, will be adapted following the definitions of the defined strategy
   * @return the instance of JDBCUserUtil to chain method calls.
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil createUserAndForget(String username, String password) { 
    createUser(username, password).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a user into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.mutiny.ext.auth.HashingStrategy#hash}
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Void> createHashedUser(String username, String hash) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createHashedUser(username, hash, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createHashedUser(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.mutiny.ext.auth.HashingStrategy#hash}
   * @return the Void instance produced by the operation.
   * @deprecated   */
  @Deprecated
  public Void createHashedUserAndAwait(String username, String hash) { 
    return (Void) createHashedUser(username, hash).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createHashedUser(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createHashedUser(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createHashedUser(String,String)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param hash the password hash, as result of {@link io.vertx.mutiny.ext.auth.HashingStrategy#hash}
   * @return the instance of JDBCUserUtil to chain method calls.
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil createHashedUserAndForget(String username, String hash) { 
    createHashedUser(username, hash).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a user role into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param username the username to be set
   * @param role a to be set
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Void> createUserRole(String username, String role) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createUserRole(username, role, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUserRole(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param username the username to be set
   * @param role a to be set
   * @return the Void instance produced by the operation.
   * @deprecated   */
  @Deprecated
  public Void createUserRoleAndAwait(String username, String role) { 
    return (Void) createUserRole(username, role).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUserRole(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUserRole(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createUserRole(String,String)} but you don't need to compose it with other operations.
   * @param username the username to be set
   * @param role a to be set
   * @return the instance of JDBCUserUtil to chain method calls.
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil createUserRoleAndForget(String username, String role) { 
    createUserRole(username, role).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Insert a role permission into a database.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param role a to be set
   * @param permission the permission to be set
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   * @deprecated   */
  @CheckReturnValue
  @Deprecated
  public io.smallrye.mutiny.Uni<Void> createRolePermission(String role, String permission) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.createRolePermission(role, permission, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createRolePermission(String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param role a to be set
   * @param permission the permission to be set
   * @return the Void instance produced by the operation.
   * @deprecated   */
  @Deprecated
  public Void createRolePermissionAndAwait(String role, String permission) { 
    return (Void) createRolePermission(role, permission).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createRolePermission(String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createRolePermission(String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil#createRolePermission(String,String)} but you don't need to compose it with other operations.
   * @param role a to be set
   * @param permission the permission to be set
   * @return the instance of JDBCUserUtil to chain method calls.
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCUserUtil createRolePermissionAndForget(String role, String permission) { 
    createRolePermission(role, permission).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  public static  JDBCUserUtil newInstance(io.vertx.ext.auth.jdbc.JDBCUserUtil arg) {
    return arg != null ? new JDBCUserUtil(arg) : null;
  }

}
