package io.vertx.mutiny.ext.auth.jdbc;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;

/**
 * Determines how the hashing is computed in the implementation
 *
 * You can implement this to provide a different hashing strategy to the default.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCHashStrategy original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.jdbc.JDBCHashStrategy.class)
public class JDBCHashStrategy {

  public static final io.smallrye.mutiny.vertx.TypeArg<JDBCHashStrategy> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JDBCHashStrategy((io.vertx.ext.auth.jdbc.JDBCHashStrategy) obj),
    JDBCHashStrategy::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCHashStrategy delegate;
  
  public JDBCHashStrategy(io.vertx.ext.auth.jdbc.JDBCHashStrategy delegate) {
    this.delegate = delegate;
  }

  public JDBCHashStrategy(Object delegate) {
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCHashStrategy)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JDBCHashStrategy() {
    this.delegate = null;
  }

  public io.vertx.ext.auth.jdbc.JDBCHashStrategy getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCHashStrategy that = (JDBCHashStrategy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx the vert.x instance
   * @return the implementation.
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.jdbc.JDBCHashStrategy createSHA512(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.jdbc.JDBCHashStrategy ret = io.vertx.mutiny.ext.auth.jdbc.JDBCHashStrategy.newInstance((io.vertx.ext.auth.jdbc.JDBCHashStrategy)io.vertx.ext.auth.jdbc.JDBCHashStrategy.createSHA512(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx the vert.x instance
   * @return the implementation.
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.jdbc.JDBCHashStrategy createPBKDF2(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.auth.jdbc.JDBCHashStrategy ret = io.vertx.mutiny.ext.auth.jdbc.JDBCHashStrategy.newInstance((io.vertx.ext.auth.jdbc.JDBCHashStrategy)io.vertx.ext.auth.jdbc.JDBCHashStrategy.createPBKDF2(vertx.getDelegate()));
    return ret;
  }

  /**
   * @return a non null salt value
   * @deprecated   */
  @Deprecated
  public String generateSalt() { 
    String ret = delegate.generateSalt();
    return ret;
  }

  /**
   * @param password the unhashed password
   * @param salt the salt
   * @param version the nonce version to use
   * @return the hashed password
   * @deprecated   */
  @Deprecated
  public String computeHash(String password, String salt, int version) { 
    String ret = delegate.computeHash(password, salt, version);
    return ret;
  }

  /**
   * @param row the row
   * @return the hashed password
   * @deprecated   */
  @Deprecated
  public String getHashedStoredPwd(JsonArray row) { 
    String ret = delegate.getHashedStoredPwd(row);
    return ret;
  }

  /**
   * @param row the row
   * @return the salt
   * @deprecated   */
  @Deprecated
  public String getSalt(JsonArray row) { 
    String ret = delegate.getSalt(row);
    return ret;
  }

  /**
   * @param nonces a json array.
   * @deprecated   */
  @Deprecated
  public void setNonces(JsonArray nonces) { 
    delegate.setNonces(nonces);
  }

  /**
   * @param hasha hash a to compare
   * @param hashb hash b to compare
   * @return true if equal
   * @deprecated   */
  @Deprecated
  public static boolean isEqual(String hasha, String hashb) { 
    boolean ret = io.vertx.ext.auth.jdbc.JDBCHashStrategy.isEqual(hasha, hashb);
    return ret;
  }

  public static  JDBCHashStrategy newInstance(io.vertx.ext.auth.jdbc.JDBCHashStrategy arg) {
    return arg != null ? new JDBCHashStrategy(arg) : null;
  }

}
