package io.vertx.mutiny.ext.auth.jdbc;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.json.JsonArray;

/**
 * Factory interface for creating {@link io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider} instances that use the Vert.x JDBC client.
 *
 * By default the hashing strategy is SHA-512. If you're already running in production this is backwards
 * compatible, however for new deployments or security upgrades it is recommended to use the PBKDF2 strategy
 * as it is the current OWASP recommendation for password storage.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.jdbc.JDBCAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.jdbc.JDBCAuth.class)
public class JDBCAuth extends io.vertx.mutiny.ext.auth.AuthProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<JDBCAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new JDBCAuth((io.vertx.ext.auth.jdbc.JDBCAuth) obj),
    JDBCAuth::getDelegate
  );

  private final io.vertx.ext.auth.jdbc.JDBCAuth delegate;
  
  public JDBCAuth(io.vertx.ext.auth.jdbc.JDBCAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public JDBCAuth(Object delegate) {
    super((io.vertx.ext.auth.jdbc.JDBCAuth)delegate);
    this.delegate = (io.vertx.ext.auth.jdbc.JDBCAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  JDBCAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.jdbc.JDBCAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCAuth that = (JDBCAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param vertx 
   * @param client the JDBC client instance
   * @return the auth provider
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.jdbc.JDBCAuth create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.jdbc.JDBCClient client) { 
    io.vertx.mutiny.ext.auth.jdbc.JDBCAuth ret = io.vertx.mutiny.ext.auth.jdbc.JDBCAuth.newInstance((io.vertx.ext.auth.jdbc.JDBCAuth)io.vertx.ext.auth.jdbc.JDBCAuth.create(vertx.getDelegate(), client.getDelegate()));
    return ret;
  }

  /**
   * @param authenticationQuery the authentication query
   * @return a reference to this for fluency
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCAuth setAuthenticationQuery(String authenticationQuery) { 
    delegate.setAuthenticationQuery(authenticationQuery);
    return this;
  }

  /**
   * @param rolesQuery the roles query
   * @return a reference to this for fluency
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCAuth setRolesQuery(String rolesQuery) { 
    delegate.setRolesQuery(rolesQuery);
    return this;
  }

  /**
   * @param permissionsQuery the permissions query
   * @return a reference to this for fluency
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCAuth setPermissionsQuery(String permissionsQuery) { 
    delegate.setPermissionsQuery(permissionsQuery);
    return this;
  }

  /**
   * @param rolePrefix a Prefix e.g.: "role:"
   * @return a reference to this for fluency
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCAuth setRolePrefix(String rolePrefix) { 
    delegate.setRolePrefix(rolePrefix);
    return this;
  }

  /**
   * @param password the unhashed password
   * @param salt the salt
   * @return the hashed password
   * @deprecated   */
  @Deprecated
  public String computeHash(String password, String salt) { 
    String ret = delegate.computeHash(password, salt);
    return ret;
  }

  /**
   * @param password the unhashed password
   * @param salt the salt
   * @param version the nonce version to use
   * @return the hashed password
   * @deprecated   */
  @Deprecated
  public String computeHash(String password, String salt, int version) { 
    String ret = delegate.computeHash(password, salt, version);
    return ret;
  }

  /**
   * @return a non null salt value
   * @deprecated   */
  @Deprecated
  public String generateSalt() { 
    String ret = delegate.generateSalt();
    return ret;
  }

  /**
   * @param nonces a List of non null Strings.
   * @return a reference to this for fluency
   * @deprecated   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.ext.auth.jdbc.JDBCAuth setNonces(JsonArray nonces) { 
    delegate.setNonces(nonces);
    return this;
  }

  /**
   * The default query to be used for authentication
   */
  public static final String DEFAULT_AUTHENTICATE_QUERY = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_AUTHENTICATE_QUERY;
  /**
   * The default query to retrieve all roles for the user
   */
  public static final String DEFAULT_ROLES_QUERY = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_ROLES_QUERY;
  /**
   * The default query to retrieve all permissions for the role
   */
  public static final String DEFAULT_PERMISSIONS_QUERY = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_PERMISSIONS_QUERY;
  /**
   * The default role prefix
   */
  public static final String DEFAULT_ROLE_PREFIX = io.vertx.ext.auth.jdbc.JDBCAuth.DEFAULT_ROLE_PREFIX;
  public static  JDBCAuth newInstance(io.vertx.ext.auth.jdbc.JDBCAuth arg) {
    return arg != null ? new JDBCAuth(arg) : null;
  }

}
