/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.spring;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spring6InstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    public static final String SENTRY_SPRING_6_ID = "sentry-spring-jakarta";
    @NotNull
    private static final String SPRING_GROUP = "org.springframework";
    @NotNull
    private static final String SPRING_6_ID = "spring-core";

    public Spring6InstallStrategy() {
        this(LoggerFactory.getLogger(Spring6InstallStrategy.class));
    }

    public Spring6InstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(6, 7, 0);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(SPRING_GROUP) && dep.getArtifactId().equals(SPRING_6_ID)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    protected Version minSupportedThirdPartyVersion() {
        return Version.create(6, 0, 0);
    }

    @Override
    protected boolean shouldInstallModule(AutoInstallState autoInstallState) {
        return autoInstallState.isInstallSpring();
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_SPRING_6_ID;
    }
}

