/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.spring;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Spring5InstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    public static final String SENTRY_SPRING_5_ID = "sentry-spring";
    @NotNull
    private static final String SPRING_GROUP = "org.springframework";
    @NotNull
    private static final String SPRING_5_ID = "spring-core";

    public Spring5InstallStrategy() {
        this(LoggerFactory.getLogger(Spring5InstallStrategy.class));
    }

    public Spring5InstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(4, 1, 0);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(SPRING_GROUP) && dep.getArtifactId().equals(SPRING_5_ID)).findFirst().orElse(null);
    }

    @Override
    @Nullable
    protected Version minSupportedThirdPartyVersion() {
        return Version.create(5, 1, 2);
    }

    @Override
    @Nullable
    protected Version maxSupportedThirdPartyVersion() {
        return Version.create(5, 9999, 9999);
    }

    @Override
    protected boolean shouldInstallModule(@NotNull AutoInstallState autoInstallState) {
        return autoInstallState.isInstallSpring();
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_SPRING_5_ID;
    }
}

