/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.autoinstall.quartz;

import io.sentry.autoinstall.AbstractIntegrationInstaller;
import io.sentry.autoinstall.AutoInstallState;
import io.sentry.semver.Version;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzInstallStrategy
extends AbstractIntegrationInstaller {
    @NotNull
    private static final String QUARTZ_GROUP = "org.quartz-scheduler";
    @NotNull
    private static final String QUARTZ_ID = "quartz";
    @NotNull
    public static final String SENTRY_QUARTZ_ID = "sentry-quartz";

    public QuartzInstallStrategy() {
        this(LoggerFactory.getLogger(QuartzInstallStrategy.class));
    }

    public QuartzInstallStrategy(@NotNull Logger logger) {
        super(logger);
    }

    @Override
    @Nullable
    protected Artifact findThirdPartyDependency(@NotNull List<Artifact> resolvedArtifacts) {
        return resolvedArtifacts.stream().filter(dep -> dep.getGroupId().equals(QUARTZ_GROUP) && dep.getArtifactId().equals(QUARTZ_ID)).findFirst().orElse(null);
    }

    @Override
    protected boolean shouldInstallModule(@NotNull AutoInstallState autoInstallState) {
        return autoInstallState.isInstallQuartz();
    }

    @Override
    @NotNull
    protected Version minSupportedSentryVersion() {
        return Version.create(6, 30, 0);
    }

    @Override
    @NotNull
    protected String sentryModuleId() {
        return SENTRY_QUARTZ_ID;
    }
}

