/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryCliProvider {
    @NotNull
    private static final Logger logger = LoggerFactory.getLogger(SentryCliProvider.class);

    @NotNull
    public static String getCliPath(@NotNull MavenProject mavenProject, @Nullable String cliPathParameter) {
        if (cliPathParameter != null && !cliPathParameter.isEmpty()) {
            return cliPathParameter;
        }
        @Nullable String pathFromProperties = SentryCliProvider.searchCliInPropertiesFile(mavenProject);
        if (pathFromProperties != null && !pathFromProperties.isEmpty()) {
            logger.info("Cli found in sentry properties, using " + pathFromProperties);
            return pathFromProperties;
        }
        @Nullable String cliSuffix = SentryCliProvider.getCliSuffix();
        if (cliSuffix != null && !cliSuffix.isEmpty()) {
            logger.info("Looking for CLI with suffix " + cliSuffix);
            @NotNull String resourcePath = "/bin/sentry-cli-" + cliSuffix;
            @Nullable String cliAbsolutePath = SentryCliProvider.searchCliInResources(resourcePath);
            if (cliAbsolutePath != null) {
                logger.info("Cli found in " + cliAbsolutePath);
                return cliAbsolutePath;
            }
            @Nullable String cliTempPath = SentryCliProvider.loadCliFromResourcesToTemp(resourcePath);
            if (cliTempPath != null) {
                logger.info("Cli found in .jar using " + cliTempPath);
                return cliTempPath;
            }
        }
        return "sentry-cli";
    }

    @Nullable
    private static String searchCliInPropertiesFile(@NotNull MavenProject mavenProject) {
        @NotNull File propertiesFileToUse = new File(mavenProject.getBasedir(), "sentry.properties");
        if (!propertiesFileToUse.exists() && mavenProject.getParent() != null) {
            propertiesFileToUse = new File(mavenProject.getParent().getBasedir(), "sentry.properties");
        }
        try {
            @NotNull Properties sentryProperties = new Properties();
            sentryProperties.load(new FileInputStream(propertiesFileToUse));
            return sentryProperties.getProperty("cli.executable");
        }
        catch (IOException e) {
            logger.info("Properties file not found");
            return null;
        }
    }

    @Nullable
    private static String getCliSuffix() {
        @NotNull String osName = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        @NotNull String osArch = System.getProperty("os.arch");
        if (osName.contains("mac")) {
            return "Darwin-universal";
        }
        if (osName.contains("linux")) {
            return osArch.equals("amd64") ? "Linux-x86_64" : "Linux-" + osArch;
        }
        if (osName.contains("win")) {
            return "Windows-i686.exe";
        }
        return null;
    }

    @Nullable
    private static String searchCliInResources(@NotNull String resourcePath) {
        File resourceFile;
        @Nullable URL resourceUrl = SentryCliProvider.class.getResource(resourcePath);
        if (resourceUrl != null && (resourceFile = new File(resourceUrl.getFile())).exists()) {
            return resourceFile.getAbsolutePath();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String loadCliFromResourcesToTemp(@NotNull String resourcePath) {
        try (@Nullable InputStream inputStream = SentryCliProvider.class.getResourceAsStream(resourcePath);){
            FileOutputStream outputStream;
            block15: {
                String string;
                @NotNull File tempFile = File.createTempFile(".sentry-cli", ".exe");
                tempFile.deleteOnExit();
                tempFile.setExecutable(true);
                outputStream = new FileOutputStream(tempFile);
                try {
                    if (inputStream == null) break block15;
                    SentryCliProvider.copy(inputStream, outputStream);
                    string = tempFile.getAbsolutePath();
                }
                catch (Throwable throwable) {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                outputStream.close();
                return string;
            }
            String string = null;
            outputStream.close();
            return string;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void copy(InputStream source, OutputStream target) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = source.read(buf)) != -1) {
            target.write(buf, 0, length);
        }
    }
}

