/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.internal.path.json.mapping;

import io.restassured.common.mapper.ObjectDeserializationContext;
import io.restassured.path.json.mapper.factory.Jackson3ObjectMapperFactory;
import io.restassured.path.json.mapping.JsonPathObjectDeserializer;
import java.lang.reflect.Type;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;

public class JsonPathJackson3ObjectDeserializer
implements JsonPathObjectDeserializer {
    private final Jackson3ObjectMapperFactory factory;

    public JsonPathJackson3ObjectDeserializer(Jackson3ObjectMapperFactory factory) {
        this.factory = factory;
    }

    private ObjectMapper createJackson3JsonMapper(Type cls, String charset) {
        return (ObjectMapper)this.factory.create(cls, charset);
    }

    @Override
    public <T> T deserialize(ObjectDeserializationContext context) {
        String object = context.getDataToDeserialize().asString();
        Type cls = context.getType();
        ObjectMapper mapper = this.createJackson3JsonMapper(cls, context.getCharset());
        JavaType javaType = mapper.constructType(cls);
        return (T)mapper.readValue(object, javaType);
    }
}

