/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.providers.serialisers;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.providers.serialisers.FileBodyHandler;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class ServerFileBodyHandler
extends FileBodyHandler
implements ServerMessageBodyWriter<File> {
    public long getSize(File o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return o.length();
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo target, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    @Override
    public void writeResponse(File o, Type genericType, ServerRequestContext context) throws WebApplicationException {
        ServerFileBodyHandler.sendFile(o, context);
    }

    static void sendFile(File file, ServerRequestContext context) {
        ByteRange byteRange;
        ResteasyReactiveRequestContext ctx = (ResteasyReactiveRequestContext)context;
        Object rangeObj = ctx.getHeader("Range", true);
        ByteRange byteRange2 = byteRange = rangeObj == null ? null : ByteRange.parse(rangeObj.toString());
        if (byteRange != null && byteRange.ranges.size() == 1) {
            ByteRange.Range range = byteRange.ranges.get(0);
            long length = range.getEnd() == -1L ? Long.MAX_VALUE : range.getEnd() - range.getStart() + 1L;
            context.serverResponse().setStatusCode(Response.Status.PARTIAL_CONTENT.getStatusCode()).sendFile(file.getAbsolutePath(), range.getStart(), length);
        } else {
            context.serverResponse().sendFile(file.getAbsolutePath(), 0L, file.length());
        }
    }

    public static class ByteRange {
        private static final Logger log = Logger.getLogger(ByteRange.class);
        private final List<Range> ranges;

        public ByteRange(List<Range> ranges) {
            this.ranges = ranges;
        }

        public int getRanges() {
            return this.ranges.size();
        }

        public long getStart(int range) {
            return this.ranges.get(range).getStart();
        }

        public long getEnd(int range) {
            return this.ranges.get(range).getEnd();
        }

        public static ByteRange parse(String rangeHeader) {
            String[] parts;
            if (rangeHeader == null || rangeHeader.length() < 7) {
                return null;
            }
            if (!rangeHeader.startsWith("bytes=")) {
                return null;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (String part : parts = rangeHeader.substring(6).split(",")) {
                try {
                    int index = part.indexOf(45);
                    if (index == 0) {
                        long val = Long.parseLong(part.substring(1));
                        if (val < 0L) {
                            log.debugf("Invalid range spec %s", (Object)rangeHeader);
                            return null;
                        }
                        ranges.add(new Range(-1L, val));
                        continue;
                    }
                    if (index == -1) {
                        log.debugf("Invalid range spec %s", (Object)rangeHeader);
                        return null;
                    }
                    long start = Long.parseLong(part.substring(0, index));
                    if (start < 0L) {
                        log.debugf("Invalid range spec %s", (Object)rangeHeader);
                        return null;
                    }
                    long end = index + 1 < part.length() ? Long.parseLong(part.substring(index + 1)) : -1L;
                    ranges.add(new Range(start, end));
                }
                catch (NumberFormatException e) {
                    log.debugf("Invalid range spec %s", (Object)rangeHeader);
                    return null;
                }
            }
            if (ranges.isEmpty()) {
                return null;
            }
            return new ByteRange(ranges);
        }

        public static class Range {
            private final long start;
            private final long end;

            public Range(long start, long end) {
                this.start = start;
                this.end = end;
            }

            public long getStart() {
                return this.start;
            }

            public long getEnd() {
                return this.end;
            }
        }
    }
}

