/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.common.ResteasyReactiveConfig;
import org.jboss.resteasy.reactive.common.model.MethodParameter;
import org.jboss.resteasy.reactive.common.model.ParameterType;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.reflection.ReflectionBeanFactoryCreator;
import org.jboss.resteasy.reactive.common.types.AllWriteableMarker;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.common.util.MediaTypeHelper;
import org.jboss.resteasy.reactive.common.util.QuarkusMultivaluedHashMap;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.common.util.types.TypeSignatureParser;
import org.jboss.resteasy.reactive.common.util.types.Types;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.parameters.AsyncResponseExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.BodyParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ContextParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.CookieParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.FormParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.HeaderParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.InjectParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.LocatableResourcePathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.MatrixParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.NullParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.ParameterExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.PathParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.QueryParamExtractor;
import org.jboss.resteasy.reactive.server.core.parameters.converters.ParameterConverter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.RuntimeResolvedConverter;
import org.jboss.resteasy.reactive.server.core.serialization.DynamicEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriter;
import org.jboss.resteasy.reactive.server.core.serialization.FixedEntityWriterArray;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeInterceptorDeployment;
import org.jboss.resteasy.reactive.server.handlers.AbortChainHandler;
import org.jboss.resteasy.reactive.server.handlers.BlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ExceptionHandler;
import org.jboss.resteasy.reactive.server.handlers.FixedProducesHandler;
import org.jboss.resteasy.reactive.server.handlers.FormBodyHandler;
import org.jboss.resteasy.reactive.server.handlers.InputHandler;
import org.jboss.resteasy.reactive.server.handlers.InstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.InvocationHandler;
import org.jboss.resteasy.reactive.server.handlers.NonBlockingHandler;
import org.jboss.resteasy.reactive.server.handlers.ParameterHandler;
import org.jboss.resteasy.reactive.server.handlers.PerRequestInstanceHandler;
import org.jboss.resteasy.reactive.server.handlers.PublisherResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.RequestDeserializeHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceLocatorHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.SseResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.VariableProducesHandler;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerMethodParameter;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyWriter;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.util.ScoreSystem;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class RuntimeResourceDeployment {
    private static final ServerRestHandler[] EMPTY_REST_HANDLER_ARRAY = new ServerRestHandler[0];
    private static final MessageBodyWriter[] EMPTY_MESSAGE_BODY_WRITERS = new MessageBodyWriter[0];
    private static final int HANDLERS_CAPACITY = 10;
    private static final Logger log = Logger.getLogger(RuntimeResourceDeployment.class);
    private final DeploymentInfo info;
    private final ServerSerialisers serialisers;
    private final ResteasyReactiveConfig resteasyReactiveConfig;
    private final Supplier<Executor> executorSupplier;
    private final Supplier<Executor> virtualExecutorSupplier;
    private final RuntimeInterceptorDeployment runtimeInterceptorDeployment;
    private final DynamicEntityWriter dynamicEntityWriter;
    private final ResourceLocatorHandler resourceLocatorHandler;
    private final boolean defaultBlocking;
    private final BlockingHandler blockingHandler;
    private final BlockingHandler blockingHandlerVirtualThread;
    private final ResponseWriterHandler responseWriterHandler;

    public RuntimeResourceDeployment(DeploymentInfo info, Supplier<Executor> executorSupplier, Supplier<Executor> virtualExecutorSupplier, RuntimeInterceptorDeployment runtimeInterceptorDeployment, DynamicEntityWriter dynamicEntityWriter, ResourceLocatorHandler resourceLocatorHandler, boolean defaultBlocking) {
        this.info = info;
        this.serialisers = info.getSerialisers();
        this.resteasyReactiveConfig = info.getResteasyReactiveConfig();
        this.executorSupplier = executorSupplier;
        this.virtualExecutorSupplier = virtualExecutorSupplier;
        this.runtimeInterceptorDeployment = runtimeInterceptorDeployment;
        this.dynamicEntityWriter = dynamicEntityWriter;
        this.resourceLocatorHandler = resourceLocatorHandler;
        this.defaultBlocking = defaultBlocking;
        this.blockingHandler = new BlockingHandler(executorSupplier);
        this.blockingHandlerVirtualThread = new BlockingHandler(virtualExecutorSupplier);
        this.responseWriterHandler = new ResponseWriterHandler(dynamicEntityWriter);
    }

    public RuntimeResource buildResourceMethod(ResourceClass clazz, ServerResourceMethod method, boolean locatableResource, URITemplate classPathTemplate, DeploymentInfo info) {
        List responseFilterHandlers;
        int i;
        Set<String> classAnnotationNames;
        List<MediaType> consumesMediaTypes;
        URITemplate methodPathTemplate = new URITemplate(method.getPath(), method.isResourceLocator());
        QuarkusMultivaluedHashMap score = new QuarkusMultivaluedHashMap();
        Map<String, Integer> pathParameterIndexes = this.buildParamIndexMap(classPathTemplate, methodPathTemplate);
        MediaType streamElementType = null;
        if (method.getStreamElementType() != null) {
            streamElementType = MediaType.valueOf((String)method.getStreamElementType());
        }
        if (method.getConsumes() == null) {
            consumesMediaTypes = Collections.emptyList();
        } else {
            consumesMediaTypes = new ArrayList(method.getConsumes().length);
            for (String s : method.getConsumes()) {
                consumesMediaTypes.add(MediaType.valueOf((String)s));
            }
        }
        Class resourceClass = DeploymentUtils.loadClass((String)clazz.getClassName());
        Class[] parameterDeclaredTypes = new Class[method.getParameters().length];
        Class[] parameterDeclaredUnresolvedTypes = new Class[method.getParameters().length];
        for (int i2 = 0; i2 < method.getParameters().length; ++i2) {
            MethodParameter parameter = method.getParameters()[i2];
            Annotation[] declaredType = parameter.declaredType;
            String declaredUnresolvedType = parameter.declaredUnresolvedType;
            parameterDeclaredTypes[i2] = DeploymentUtils.loadClass((String)declaredType);
            parameterDeclaredUnresolvedTypes[i2] = parameterDeclaredTypes[i2];
            if (declaredType.equals(declaredUnresolvedType)) continue;
            parameterDeclaredUnresolvedTypes[i2] = DeploymentUtils.loadClass((String)declaredUnresolvedType);
        }
        Annotation[] resourceClassAnnotations = resourceClass.getAnnotations();
        if (resourceClassAnnotations.length == 0) {
            classAnnotationNames = Collections.emptySet();
        } else {
            classAnnotationNames = new HashSet(resourceClassAnnotations.length);
            for (Annotation annotation : resourceClassAnnotations) {
                classAnnotationNames.add(annotation.annotationType().getName());
            }
        }
        ResteasyReactiveResourceInfo lazyMethod = new ResteasyReactiveResourceInfo(method.getName(), resourceClass, parameterDeclaredUnresolvedTypes, classAnnotationNames, method.getMethodAnnotationNames(), !this.defaultBlocking && !method.isBlocking());
        RuntimeInterceptorDeployment.MethodInterceptorContext interceptorDeployment = this.runtimeInterceptorDeployment.forMethod(method, lazyMethod);
        ServerRestHandler interceptorHandler = interceptorDeployment.setupInterceptorHandler();
        ArrayList<ServerRestHandler> abortHandlingChain = new ArrayList<ServerRestHandler>(3 + (interceptorHandler != null ? 1 : 0));
        ArrayList<ServerRestHandler> handlers = new ArrayList<ServerRestHandler>(10);
        handlers.add(null);
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_MATCH);
        if (interceptorHandler != null) {
            handlers.add(interceptorHandler);
        }
        Optional<Object> blockingHandlerIndex = Optional.empty();
        if (!this.defaultBlocking) {
            if (method.isBlocking()) {
                if (method.isRunOnVirtualThread()) {
                    handlers.add(this.blockingHandlerVirtualThread);
                } else {
                    handlers.add(this.blockingHandler);
                }
                blockingHandlerIndex = Optional.of(handlers.size() - 1);
                score.add((Object)ScoreSystem.Category.Execution, (Object)ScoreSystem.Diagnostic.ExecutionBlocking);
            } else {
                if (method.isRunOnVirtualThread()) {
                    log.error((Object)"a method was both non blocking and @RunOnVirtualThread, it is now considered @RunOnVirtual and blocking");
                    handlers.add(this.blockingHandlerVirtualThread);
                } else {
                    handlers.add(NonBlockingHandler.INSTANCE);
                }
                score.add((Object)ScoreSystem.Category.Execution, (Object)ScoreSystem.Diagnostic.ExecutionNonBlocking);
            }
        }
        if (method.getReturnType().equals("Lio/vertx/core/file/AsyncFile;") && interceptorDeployment.hasWriterInterceptors()) {
            throw new RuntimeException("Endpoints that return an AsyncFile cannot have any WriterInterceptor set");
        }
        boolean hasReadBodyRequestFilters = false;
        if (method.getHttpMethod() != null) {
            List<ResourceRequestFilterHandler> containerRequestFilterHandlers = interceptorDeployment.setupRequestFilterHandler();
            if (blockingHandlerIndex.isPresent()) {
                int initialIndex = (Integer)blockingHandlerIndex.get();
                for (int i3 = 0; i3 < containerRequestFilterHandlers.size(); ++i3) {
                    ResourceRequestFilterHandler handler = containerRequestFilterHandlers.get(i3);
                    if (handler.isNonBlockingRequired()) {
                        handlers.add(initialIndex + i3, handler);
                    } else {
                        handlers.add(handler);
                    }
                    if (!handler.isReadBody()) continue;
                    hasReadBodyRequestFilters = true;
                }
            } else {
                handlers.addAll(containerRequestFilterHandlers);
            }
        }
        MethodParameter[] parameters = method.getParameters();
        MethodParameter bodyParameter = null;
        int bodyParameterIndex = -1;
        for (int i4 = 0; i4 < parameters.length; ++i4) {
            MethodParameter param = parameters[i4];
            if (param.parameterType != ParameterType.BODY) continue;
            bodyParameter = param;
            bodyParameterIndex = i4;
            break;
        }
        boolean checkReadBodyRequestFilters = false;
        if (method.isFormParamRequired() || method.isMultipart()) {
            handlers.add(new FormBodyHandler(bodyParameter != null, this.executorSupplier));
            checkReadBodyRequestFilters = true;
        } else if (bodyParameter != null && !this.defaultBlocking && !method.isBlocking()) {
            handlers.add(new InputHandler(this.resteasyReactiveConfig.getInputBufferSize(), this.executorSupplier));
            checkReadBodyRequestFilters = true;
        }
        if (checkReadBodyRequestFilters && hasReadBodyRequestFilters) {
            ArrayList<ServerRestHandler> readBodyRequestFilters = new ArrayList<ServerRestHandler>(1);
            for (i = handlers.size() - 2; i >= 0; --i) {
                ResourceRequestFilterHandler resourceRequestFilterHandler;
                ServerRestHandler serverRestHandler = (ServerRestHandler)handlers.get(i);
                if (!(serverRestHandler instanceof ResourceRequestFilterHandler) || !(resourceRequestFilterHandler = (ResourceRequestFilterHandler)serverRestHandler).isReadBody()) continue;
                readBodyRequestFilters.add((ServerRestHandler)handlers.remove(i));
            }
            handlers.addAll(readBodyRequestFilters);
        }
        if (bodyParameter != null) {
            Class typeClass;
            Type genericType = typeClass = DeploymentUtils.loadClass((String)bodyParameter.declaredType);
            if (!bodyParameter.type.equals(bodyParameter.declaredType)) {
                genericType = TypeSignatureParser.parse((String)bodyParameter.signature);
            }
            handlers.add(new RequestDeserializeHandler(typeClass, genericType, consumesMediaTypes.isEmpty() ? null : (MediaType)consumesMediaTypes.get(0), this.serialisers, bodyParameterIndex));
        }
        ServerRestHandler instanceHandler = null;
        if (!locatableResource) {
            if (clazz.isPerRequestResource()) {
                instanceHandler = new PerRequestInstanceHandler((BeanFactory<Object>)clazz.getFactory(), info.getClientProxyUnwrapper());
                score.add((Object)ScoreSystem.Category.Resource, (Object)ScoreSystem.Diagnostic.ResourcePerRequest);
            } else {
                instanceHandler = new InstanceHandler((BeanFactory<Object>)clazz.getFactory());
                score.add((Object)ScoreSystem.Category.Resource, (Object)ScoreSystem.Diagnostic.ResourceSingleton);
            }
            handlers.add(instanceHandler);
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.RESOLVE_METHOD_PARAMETERS);
        for (i = 0; i < parameters.length; ++i) {
            boolean userProviderConvertersExist;
            ServerMethodParameter param = (ServerMethodParameter)parameters[i];
            boolean single = param.isSingle();
            ParameterExtractor extractor = this.parameterExtractor(pathParameterIndexes, locatableResource, param.parameterType, param.type, param.name, single, param.encoded, param.customParameterExtractor);
            ParameterConverter converter = null;
            ParamConverterProviders paramConverterProviders = info.getParamConverterProviders();
            boolean bl = userProviderConvertersExist = !paramConverterProviders.getParamConverterProviders().isEmpty();
            if (param.converter != null) {
                converter = (ParameterConverter)param.converter.get();
                if (userProviderConvertersExist) {
                    Method javaMethod = lazyMethod.getMethod();
                    Class<?>[] parameterTypes = javaMethod.getParameterTypes();
                    Type[] genericParameterTypes = javaMethod.getGenericParameterTypes();
                    Annotation[][] parameterAnnotations = javaMethod.getParameterAnnotations();
                    converter.init(paramConverterProviders, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
                    converter = new RuntimeResolvedConverter(converter);
                    converter.init(paramConverterProviders, parameterTypes[i], genericParameterTypes[i], parameterAnnotations[i]);
                }
            }
            handlers.add(new ParameterHandler(i, param.getDefaultValue(), extractor, converter, param.parameterType, param.isObtainedAsCollection(), param.isOptional()));
        }
        this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.BEFORE_METHOD_INVOKE);
        EndpointInvoker invoker = method.getInvoker().get();
        ServerRestHandler alternate = this.alternateInvoker(method, invoker);
        if (alternate != null) {
            handlers.add(alternate);
        } else {
            handlers.add(new InvocationHandler(invoker));
        }
        boolean afterMethodInvokeHandlersAdded = this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE);
        boolean afterMethodInvokeHandlersSecondRoundAdded = this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_METHOD_INVOKE_SECOND_ROUND);
        if (afterMethodInvokeHandlersAdded || afterMethodInvokeHandlersSecondRoundAdded) {
            this.addStreamingResponseCustomizers(method, handlers);
        }
        Type returnType = TypeSignatureParser.parse((String)method.getReturnType());
        Type effectiveReturnType = Types.getEffectiveReturnType((Type)returnType);
        Class rawEffectiveReturnType = Types.getRawType((Type)effectiveReturnType);
        ServerMediaType serverMediaType = null;
        if (method.getProduces() != null && method.getProduces().length > 0) {
            serverMediaType = new ServerMediaType(ServerMediaType.mediaTypesFromArray((String[])method.getProduces()), StandardCharsets.UTF_8.name(), false);
        }
        if (method.getHttpMethod() == null) {
            handlers.add(this.resourceLocatorHandler);
        } else if (!Response.class.isAssignableFrom(rawEffectiveReturnType)) {
            if (method.getProduces() != null && method.getProduces().length > 0) {
                if (method.getProduces().length == 1) {
                    MediaType mediaType = MediaType.valueOf((String)method.getProduces()[0]);
                    if (mediaType.isWildcardType() || mediaType.isWildcardSubtype()) {
                        handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                        score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                    } else if (rawEffectiveReturnType != Void.class && rawEffectiveReturnType != Void.TYPE) {
                        List buildTimeWriters = this.serialisers.findBuildTimeWriters(rawEffectiveReturnType, RuntimeType.SERVER, MediaTypeHelper.toListOfMediaType((String[])method.getProduces()));
                        if (buildTimeWriters == null) {
                            handlers.add(new FixedProducesHandler(mediaType, this.dynamicEntityWriter));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                        } else if (buildTimeWriters.isEmpty()) {
                            log.warn((Object)("Cannot find any combination of response writers for the method " + clazz.getClassName() + "#" + method.getName() + "(" + Arrays.toString(method.getParameters()) + ")"));
                            handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                        } else if (this.isSingleEffectiveWriter(buildTimeWriters)) {
                            MessageBodyWriter writer = (MessageBodyWriter)buildTimeWriters.get(0);
                            handlers.add(new FixedProducesHandler(mediaType, new FixedEntityWriter(writer, this.serialisers)));
                            if (writer instanceof ServerMessageBodyWriter) {
                                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTimeDirect(writer));
                            } else {
                                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTime(writer));
                            }
                        } else {
                            handlers.add(new FixedProducesHandler(mediaType, new FixedEntityWriterArray(buildTimeWriters.toArray(EMPTY_MESSAGE_BODY_WRITERS), this.serialisers)));
                            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterBuildTimeMultiple(buildTimeWriters));
                        }
                    } else {
                        score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterNotRequired);
                    }
                } else {
                    handlers.add(new VariableProducesHandler(serverMediaType, this.serialisers));
                    score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
                }
            } else {
                score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
            }
        } else {
            score.add((Object)ScoreSystem.Category.Writer, (Object)ScoreSystem.Diagnostic.WriterRunTime);
        }
        if (method.isSse()) {
            handlers.add(SseResponseWriterHandler.INSTANCE);
            responseFilterHandlers = Collections.emptyList();
        } else {
            this.addResponseHandler(method, handlers);
            this.addHandlers(handlers, clazz, method, info, HandlerChainCustomizer.Phase.AFTER_RESPONSE_CREATED);
            responseFilterHandlers = new ArrayList<ServerRestHandler>(interceptorDeployment.setupResponseFilterHandler());
            handlers.addAll(responseFilterHandlers);
            handlers.add(this.responseWriterHandler);
        }
        if (!clazz.resourceExceptionMapper().isEmpty() && instanceHandler != null) {
            abortHandlingChain.add(instanceHandler);
        }
        abortHandlingChain.add(ExceptionHandler.INSTANCE);
        abortHandlingChain.add(ResponseHandler.NO_CUSTOMIZER_INSTANCE);
        abortHandlingChain.addAll(responseFilterHandlers);
        abortHandlingChain.add(this.responseWriterHandler);
        handlers.set(0, new AbortChainHandler(abortHandlingChain.toArray(EMPTY_REST_HANDLER_ARRAY)));
        return new RuntimeResource(method.getHttpMethod(), methodPathTemplate, classPathTemplate, method.getProduces() == null ? null : serverMediaType, consumesMediaTypes, invoker, (BeanFactory<Object>)clazz.getFactory(), handlers.toArray(EMPTY_REST_HANDLER_ARRAY), method.getName(), parameterDeclaredTypes, effectiveReturnType, method.isBlocking(), method.isRunOnVirtualThread(), resourceClass, lazyMethod, pathParameterIndexes, (Map<ScoreSystem.Category, List<ScoreSystem.Diagnostic>>)(info.isDevelopmentMode() ? score : null), streamElementType, clazz.resourceExceptionMapper());
    }

    private void addResponseHandler(ServerResourceMethod method, List<ServerRestHandler> handlers) {
        if (method.getHandlerChainCustomizers().isEmpty()) {
            handlers.add(ResponseHandler.NO_CUSTOMIZER_INSTANCE);
        } else {
            ArrayList<ResponseHandler.ResponseBuilderCustomizer> customizers = new ArrayList<ResponseHandler.ResponseBuilderCustomizer>(method.getHandlerChainCustomizers().size());
            for (int i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
                ResponseHandler.ResponseBuilderCustomizer customizer = method.getHandlerChainCustomizers().get(i).successfulInvocationResponseBuilderCustomizer(method);
                if (customizer == null) continue;
                customizers.add(customizer);
            }
            handlers.add(new ResponseHandler(customizers));
        }
    }

    private void addStreamingResponseCustomizers(ServerResourceMethod method, List<ServerRestHandler> handlers) {
        int i;
        ArrayList<PublisherResponseHandler.StreamingResponseCustomizer> customizers = new ArrayList<PublisherResponseHandler.StreamingResponseCustomizer>(method.getHandlerChainCustomizers().size());
        for (i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            PublisherResponseHandler.StreamingResponseCustomizer streamingResponseCustomizer = method.getHandlerChainCustomizers().get(i).streamingResponseCustomizer(method);
            if (streamingResponseCustomizer == null) continue;
            customizers.add(streamingResponseCustomizer);
        }
        if (!customizers.isEmpty()) {
            for (i = 0; i < handlers.size(); ++i) {
                ServerRestHandler serverRestHandler = handlers.get(i);
                if (!(serverRestHandler instanceof PublisherResponseHandler)) continue;
                ((PublisherResponseHandler)serverRestHandler).setStreamingResponseCustomizers(customizers);
                return;
            }
        }
    }

    private boolean isSingleEffectiveWriter(List<MessageBodyWriter<?>> buildTimeWriters) {
        if (buildTimeWriters.size() == 1) {
            return true;
        }
        return buildTimeWriters.get(0) instanceof AllWriteableMarker;
    }

    private boolean addHandlers(List<ServerRestHandler> handlers, ResourceClass clazz, ServerResourceMethod method, DeploymentInfo info, HandlerChainCustomizer.Phase phase) {
        int i;
        int originalHandlersSize = handlers.size();
        for (i = 0; i < info.getGlobalHandlerCustomizers().size(); ++i) {
            handlers.addAll(info.getGlobalHandlerCustomizers().get(i).handlers(phase, clazz, method));
        }
        for (i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            handlers.addAll(method.getHandlerChainCustomizers().get(i).handlers(phase, clazz, method));
        }
        return originalHandlersSize != handlers.size();
    }

    private ServerRestHandler alternateInvoker(ServerResourceMethod method, EndpointInvoker invoker) {
        for (int i = 0; i < method.getHandlerChainCustomizers().size(); ++i) {
            ServerRestHandler ret = method.getHandlerChainCustomizers().get(i).alternateInvocationHandler(invoker);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public ParameterExtractor parameterExtractor(Map<String, Integer> pathParameterIndexes, boolean locatableResource, ParameterType type, String javaType, String name, boolean single, boolean encoded, ParameterExtractor customExtractor) {
        switch (type) {
            case HEADER: {
                return new HeaderParamExtractor(name, single);
            }
            case COOKIE: {
                return new CookieParamExtractor(name);
            }
            case FORM: {
                return new FormParamExtractor(name, single, encoded);
            }
            case PATH: {
                Integer index = pathParameterIndexes.get(name);
                ParameterExtractor extractor = index == null ? (locatableResource ? new LocatableResourcePathParamExtractor(name) : new NullParamExtractor()) : new PathParamExtractor(index, encoded, single);
                return extractor;
            }
            case CONTEXT: {
                return new ContextParamExtractor(javaType);
            }
            case ASYNC_RESPONSE: {
                return new AsyncResponseExtractor();
            }
            case QUERY: {
                QueryParamExtractor extractor = new QueryParamExtractor(name, single, encoded);
                return extractor;
            }
            case BODY: {
                return new BodyParamExtractor();
            }
            case MATRIX: {
                MatrixParamExtractor extractor = new MatrixParamExtractor(name, single, encoded);
                return extractor;
            }
            case BEAN: {
                return new InjectParamExtractor(this.info.getFactoryCreator().apply(DeploymentUtils.loadClass((String)javaType)));
            }
            case MULTI_PART_FORM: {
                return new InjectParamExtractor((BeanFactory<Object>)new ReflectionBeanFactoryCreator().apply(javaType));
            }
            case CUSTOM: {
                return customExtractor;
            }
        }
        throw new RuntimeException("Unknown param type: " + type);
    }

    public Map<String, Integer> buildParamIndexMap(URITemplate classPathTemplate, URITemplate methodPathTemplate) {
        HashMap<String, Integer> pathParameterIndexes = new HashMap<String, Integer>();
        int pathCount = 0;
        if (classPathTemplate != null) {
            for (URITemplate.TemplateComponent i : classPathTemplate.components) {
                if (i.name != null) {
                    pathParameterIndexes.put(i.name, pathCount++);
                    continue;
                }
                if (i.names == null) continue;
                for (String nm : i.names) {
                    pathParameterIndexes.put(nm, pathCount++);
                }
            }
        }
        for (URITemplate.TemplateComponent i : methodPathTemplate.components) {
            if (i.name != null) {
                pathParameterIndexes.put(i.name, pathCount++);
                continue;
            }
            if (i.names == null) continue;
            for (String nm : i.names) {
                pathParameterIndexes.put(nm, pathCount++);
            }
        }
        return pathParameterIndexes;
    }
}

